"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlNotificationsContextProvider = exports.MlNotificationsContext = void 0;
exports.useMlNotifications = useMlNotifications;
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _moment = _interopRequireDefault(require("moment"));
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _kibana = require("../kibana");
var _storage = require("../../../../common/types/storage");
var _hooks = require("../../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NOTIFICATIONS_CHECK_INTERVAL = 60000;
const defaultCounts = {
  info: 0,
  error: 0,
  warning: 0
};
const MlNotificationsContext = /*#__PURE__*/_react.default.createContext({
  notificationsCounts: defaultCounts,
  lastCheckedAt: null,
  latestRequestedAt: null,
  setLastCheckedAt: () => {}
});
exports.MlNotificationsContext = MlNotificationsContext;
const MlNotificationsContextProvider = ({
  children
}) => {
  const {
    services: {
      mlServices: {
        mlApiServices
      },
      application: {
        capabilities
      }
    }
  } = (0, _kibana.useMlKibana)();
  const canGetJobs = capabilities.ml.canGetJobs;
  const canGetDataFrameAnalytics = capabilities.ml.canGetDataFrameAnalytics;
  const canGetTrainedModels = capabilities.ml.canGetTrainedModels;
  const canGetNotifications = canGetJobs && canGetDataFrameAnalytics && canGetTrainedModels;
  const [lastCheckedAt, setLastCheckedAt] = (0, _mlLocalStorage.useStorage)(_storage.ML_NOTIFICATIONS_LAST_CHECKED_AT);
  const lastCheckedAt$ = (0, _hooks.useAsObservable)(lastCheckedAt);

  /** Holds the value used for the actual request */
  const [latestRequestedAt, setLatestRequestedAt] = (0, _react.useState)(null);
  const [notificationsCounts, setNotificationsCounts] = (0, _react.useState)(defaultCounts);
  (0, _react.useEffect)(function startPollingNotifications() {
    if (!canGetNotifications) return;
    const subscription = (0, _rxjs.combineLatest)([lastCheckedAt$, (0, _rxjs.timer)(0, NOTIFICATIONS_CHECK_INTERVAL)]).pipe(
    // Use the latest check time or 7 days ago by default.
    (0, _operators.map)(([lastChecked]) => lastChecked !== null && lastChecked !== void 0 ? lastChecked : (0, _moment.default)().subtract(7, 'd').valueOf()), (0, _operators.tap)(lastCheckedAtQuery => {
      setLatestRequestedAt(lastCheckedAtQuery);
    }), (0, _operators.switchMap)(lastCheckedAtQuery => mlApiServices.notifications.countMessages$({
      lastCheckedAt: lastCheckedAtQuery
    })), (0, _operators.retry)({
      delay: NOTIFICATIONS_CHECK_INTERVAL
    })).subscribe(response => {
      setNotificationsCounts((0, _mlIsPopulatedObject.isPopulatedObject)(response) ? response : defaultCounts);
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [canGetNotifications, lastCheckedAt$, mlApiServices.notifications]);
  return /*#__PURE__*/_react.default.createElement(MlNotificationsContext.Provider, {
    value: {
      notificationsCounts,
      lastCheckedAt,
      setLastCheckedAt,
      latestRequestedAt
    }
  }, children);
};
exports.MlNotificationsContextProvider = MlNotificationsContextProvider;
function useMlNotifications() {
  return (0, _react.useContext)(MlNotificationsContext);
}