"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCloudCheck = useCloudCheck;
exports.useMlNodeAvailableCheck = useMlNodeAvailableCheck;
exports.useMlNodeCheck = useMlNodeCheck;
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
var _http_service = require("../../services/http_service");
var _ml_api_service = require("../../services/ml_api_service");
var _ml_server_info = require("../../services/ml_server_info");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useMlNodeAvailableCheck() {
  const {
    mlNodesAvailable
  } = useMlNodeCheck();
  const {
    isCloud,
    deploymentId,
    isCloudTrial
  } = useCloudCheck();
  return {
    mlNodesAvailable,
    isCloud,
    deploymentId,
    isCloudTrial
  };
}
function useMlNodeCheck() {
  const {
    http
  } = (0, _public.useKibana)().services;
  const ml = (0, _react.useMemo)(() => (0, _ml_api_service.mlApiServicesProvider)(new _http_service.HttpService(http)), [http]);
  const [mlNodeCount, setMlNodeCount] = (0, _react.useState)(null);
  const [lazyMlNodeCount, setLazyMlNodeCount] = (0, _react.useState)(null);
  const [userHasPermissionToViewMlNodeCount, setUserHasPermissionToViewMlNodeCount] = (0, _react.useState)(null);
  const [mlNodesAvailable, setMlNodesAvailable] = (0, _react.useState)(true);
  const checkNodes = (0, _react.useCallback)(async () => {
    try {
      const {
        count,
        lazyNodeCount
      } = await ml.mlNodeCount();
      setMlNodeCount(count);
      setLazyMlNodeCount(lazyNodeCount);
      setUserHasPermissionToViewMlNodeCount(true);
      setMlNodesAvailable(count !== 0 || lazyNodeCount !== 0);
    } catch (error) {
      if (error.statusCode === 403) {
        setUserHasPermissionToViewMlNodeCount(false);
        setMlNodesAvailable(true);
      }
    }
  }, [ml]);
  (0, _react.useEffect)(function checkNodesInit() {
    checkNodes();
  }, [checkNodes]);
  return {
    mlNodeCount,
    lazyMlNodeCount,
    userHasPermissionToViewMlNodeCount,
    mlNodesAvailable,
    refresh: checkNodes
  };
}
const defaultCloudInfo = {
  cloudId: null,
  isCloud: false,
  isCloudTrial: false,
  deploymentId: null
};
function useCloudCheck() {
  const {
    http
  } = (0, _public.useKibana)().services;
  const ml = (0, _react.useMemo)(() => (0, _ml_api_service.mlApiServicesProvider)(new _http_service.HttpService(http)), [http]);
  const [cloudInfo, setCloudInfo] = (0, _react.useState)(defaultCloudInfo);
  const loadInfo = (0, _react.useCallback)(async () => {
    try {
      var _resp$cloudId;
      const resp = await ml.mlInfo();
      setCloudInfo({
        cloudId: (_resp$cloudId = resp.cloudId) !== null && _resp$cloudId !== void 0 ? _resp$cloudId : null,
        isCloud: resp.cloudId !== undefined,
        isCloudTrial: resp.isCloudTrial === true,
        deploymentId: !resp.cloudId ? null : (0, _ml_server_info.extractDeploymentId)(resp.cloudId)
      });
    } catch (error) {
      if (error.statusCode === 403) {
        setCloudInfo(defaultCloudInfo);
      }
    }
  }, [ml]);
  (0, _react.useEffect)(function loadInfoInit() {
    loadInfo();
  }, [loadInfo]);
  return cloudInfo;
}