"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddInferencePipelineHorizontalSteps = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const steps = Object.values(_constants.ADD_INFERENCE_PIPELINE_STEPS);
const AddInferencePipelineHorizontalSteps = /*#__PURE__*/(0, _react.memo)(({
  step,
  setStep,
  isDetailsStepValid,
  isConfigureProcessorStepValid
}) => {
  const currentStepIndex = steps.findIndex(s => s === step);
  const navSteps = [{
    // Details
    onClick: () => setStep(_constants.ADD_INFERENCE_PIPELINE_STEPS.DETAILS),
    status: isDetailsStepValid ? 'complete' : 'incomplete',
    title: _i18n.i18n.translate('xpack.ml.inferencePipeline.content.indices.transforms.addInferencePipelineModal.steps.details.title', {
      defaultMessage: 'Details'
    })
  }, {
    // Processor configuration
    onClick: () => {
      if (!isDetailsStepValid) return;
      setStep(_constants.ADD_INFERENCE_PIPELINE_STEPS.CONFIGURE_PROCESSOR);
    },
    status: isDetailsStepValid && isConfigureProcessorStepValid && currentStepIndex > 1 ? 'complete' : 'incomplete',
    title: _i18n.i18n.translate('xpack.ml.inferencePipeline.content.indices.transforms.addInferencePipelineModal.steps.configureProcessor.title', {
      defaultMessage: 'Configure processor'
    })
  }, {
    // handle failures
    onClick: () => {
      if (!isDetailsStepValid) return;
      setStep(_constants.ADD_INFERENCE_PIPELINE_STEPS.ON_FAILURE);
    },
    status: currentStepIndex > 2 ? 'complete' : 'incomplete',
    title: _i18n.i18n.translate('xpack.ml.inferencePipeline.content.indices.transforms.addInferencePipelineModal.steps.handleFailures.title', {
      defaultMessage: 'Handle failures'
    })
  }, {
    // Test
    onClick: () => {
      if (!isConfigureProcessorStepValid || !isDetailsStepValid) return;
      setStep(_constants.ADD_INFERENCE_PIPELINE_STEPS.TEST);
    },
    status: currentStepIndex > 3 ? 'complete' : 'incomplete',
    title: _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.transforms.addInferencePipelineModal.steps.test.title', {
      defaultMessage: 'Test (Optional)'
    })
  }, {
    // Review and Create
    onClick: () => {
      if (!isConfigureProcessorStepValid) return;
      setStep(_constants.ADD_INFERENCE_PIPELINE_STEPS.CREATE);
    },
    status: isDetailsStepValid && isConfigureProcessorStepValid ? 'incomplete' : 'disabled',
    title: _i18n.i18n.translate('xpack.ml.inferencePipeline.content.indices.transforms.addInferencePipelineModal.steps.create.title', {
      defaultMessage: 'Create'
    })
  }];
  switch (step) {
    case _constants.ADD_INFERENCE_PIPELINE_STEPS.DETAILS:
      navSteps[0].status = 'current';
      break;
    case _constants.ADD_INFERENCE_PIPELINE_STEPS.CONFIGURE_PROCESSOR:
      navSteps[1].status = 'current';
      break;
    case _constants.ADD_INFERENCE_PIPELINE_STEPS.ON_FAILURE:
      navSteps[2].status = 'current';
      break;
    case _constants.ADD_INFERENCE_PIPELINE_STEPS.TEST:
      navSteps[3].status = 'current';
      break;
    case _constants.ADD_INFERENCE_PIPELINE_STEPS.CREATE:
      navSteps[4].status = 'current';
      break;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiStepsHorizontal, {
    steps: navSteps,
    size: "s"
  });
});
exports.AddInferencePipelineHorizontalSteps = AddInferencePipelineHorizontalSteps;