"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateDataViewTimeField = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateDataViewTimeField = ({
  dataViewAvailableTimeFields,
  dataViewTimeField,
  onTimeFieldChanged
}) => {
  const noTimeFieldLabel = _i18n.i18n.translate('xpack.ml.dataViewUtils.noTimeFieldOptionLabel', {
    defaultMessage: "I don't want to use the time field option"
  });
  const noTimeFieldOption = {
    text: noTimeFieldLabel,
    value: undefined
  };
  const disabledDividerOption = {
    disabled: true,
    text: '───',
    value: ''
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataViewUtils.dataViewTimeFieldLabel",
      defaultMessage: "Time field for data view"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataViewUtils.dataViewTimeFieldHelpText",
      defaultMessage: "Select a primary time field for use with the global time filter."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: [...dataViewAvailableTimeFields.map(text => ({
      text
    })), disabledDividerOption, noTimeFieldOption],
    value: dataViewTimeField,
    onChange: onTimeFieldChanged,
    "data-test-subj": "mlDataViewTimeFieldSelect"
  }));
};
exports.CreateDataViewTimeField = CreateDataViewTimeField;