"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _common_providers = require("../../../apps/common_providers");
var _pod_metrics_table = require("./pod_metrics_table");
var _use_pod_metrics_table = require("./use_pod_metrics_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HookedPodMetricsTable({
  timerange,
  filterClauseDsl,
  metricsClient
}) {
  const podMetricsTableProps = (0, _use_pod_metrics_table.usePodMetricsTable)({
    timerange,
    filterClauseDsl,
    metricsClient
  });
  return /*#__PURE__*/_react.default.createElement(_pod_metrics_table.PodMetricsTable, podMetricsTableProps);
}
function PodMetricsTableWithProviders({
  timerange,
  filterClauseDsl,
  sourceId,
  metricsClient,
  ...coreProvidersProps
}) {
  return /*#__PURE__*/_react.default.createElement(_common_providers.CoreProviders, coreProvidersProps, /*#__PURE__*/_react.default.createElement(HookedPodMetricsTable, {
    timerange: timerange,
    filterClauseDsl: filterClauseDsl,
    metricsClient: metricsClient
  }));
}

// Use default export for lazy loading.
// eslint-disable-next-line import/no-default-export
var _default = PodMetricsTableWithProviders;
exports.default = _default;
module.exports = exports.default;