"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLayerInstance = createLayerInstance;
exports.getDataFilters = exports.getCustomIcons = void 0;
exports.getDataRequestDescriptor = getDataRequestDescriptor;
exports.getEmbeddableSearchContext = exports.getEditState = exports.getDrawState = void 0;
exports.getExecutionContext = getExecutionContext;
exports.getHiddenLayerIds = exports.getHasLockedTooltips = exports.getGoto = exports.getGeoFieldNames = exports.getFilters = void 0;
exports.getLayerById = getLayerById;
exports.getLayerDescriptor = getLayerDescriptor;
exports.isUsingSearch = exports.isMapLoading = exports.hasPreviewLayers = exports.hasMapSettingsChanges = exports.hasDirtyState = exports.getWaitingForMapReadyLayerListRaw = exports.getTimeslice = exports.getTimeFilters = exports.getSpatialFiltersLayer = exports.getSelectedLayerJoinDescriptors = exports.getSelectedLayerId = exports.getSelectedLayer = exports.getSearchSessionMapBuffer = exports.getSearchSessionId = exports.getQueryableUniqueIndexPatternIds = exports.getQuery = exports.getOpenTooltips = exports.getMouseCoordinates = exports.getMapZoom = exports.getMapSettings = exports.getMapReady = exports.getMapInitError = exports.getMapExtent = exports.getMapColors = exports.getMapCenter = exports.getMapBuffer = exports.getLayerListRaw = exports.getLayerListConfigOnly = exports.getLayerList = void 0;
var _reselect = require("reselect");
var _lodash = _interopRequireDefault(require("lodash"));
var _raster_tile_layer = require("../classes/layers/raster_tile_layer/raster_tile_layer");
var _ems_vector_tile_layer = require("../classes/layers/ems_vector_tile_layer/ems_vector_tile_layer");
var _vector_layer = require("../classes/layers/vector_layer");
var _vector_style = require("../classes/styles/vector/vector_style");
var _layer_group = require("../classes/layers/layer_group");
var _heatmap_layer = require("../classes/layers/heatmap_layer");
var _kibana_services = require("../kibana_services");
var _non_serializable_instances = require("../reducers/non_serializable_instances");
var _copy_persistent_state = require("../reducers/copy_persistent_state");
var _inner_join = require("../classes/joins/inner_join");
var _create_source_instance = require("../classes/sources/create_source_instance");
var _geojson_file_source = require("../classes/sources/geojson_file_source");
var _constants = require("../../common/constants");
var _elasticsearch_util = require("../../common/elasticsearch_util");
var _ui_selectors = require("./ui_selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-ignore

function createJoinInstances(vectorLayerDescriptor, source) {
  return vectorLayerDescriptor.joins ? vectorLayerDescriptor.joins.map(joinDescriptor => {
    return new _inner_join.InnerJoin(joinDescriptor, source);
  }) : [];
}
function createLayerInstance(layerDescriptor, customIcons, chartsPaletteServiceGetColor) {
  if (layerDescriptor.type === _constants.LAYER_TYPE.LAYER_GROUP) {
    return new _layer_group.LayerGroup({
      layerDescriptor: layerDescriptor
    });
  }
  const source = (0, _create_source_instance.createSourceInstance)(layerDescriptor.sourceDescriptor);
  switch (layerDescriptor.type) {
    case _constants.LAYER_TYPE.RASTER_TILE:
      return new _raster_tile_layer.RasterTileLayer({
        layerDescriptor,
        source: source
      });
    case _constants.LAYER_TYPE.EMS_VECTOR_TILE:
      return new _ems_vector_tile_layer.EmsVectorTileLayer({
        layerDescriptor: layerDescriptor,
        source: source
      });
    case _constants.LAYER_TYPE.HEATMAP:
      return new _heatmap_layer.HeatmapLayer({
        layerDescriptor: layerDescriptor,
        source: source
      });
    case _constants.LAYER_TYPE.GEOJSON_VECTOR:
      return new _vector_layer.GeoJsonVectorLayer({
        layerDescriptor: layerDescriptor,
        source: source,
        joins: createJoinInstances(layerDescriptor, source),
        customIcons,
        chartsPaletteServiceGetColor
      });
    case _constants.LAYER_TYPE.BLENDED_VECTOR:
      return new _vector_layer.BlendedVectorLayer({
        layerDescriptor: layerDescriptor,
        source: source,
        customIcons,
        chartsPaletteServiceGetColor
      });
    case _constants.LAYER_TYPE.MVT_VECTOR:
      return new _vector_layer.MvtVectorLayer({
        layerDescriptor: layerDescriptor,
        source: source,
        joins: createJoinInstances(layerDescriptor, source),
        customIcons
      });
    default:
      throw new Error(`Unrecognized layerType ${layerDescriptor.type}`);
  }
}
const getMapSettings = ({
  map
}) => map.settings;
exports.getMapSettings = getMapSettings;
const getRollbackMapSettings = ({
  map
}) => map.__rollbackSettings;
const hasMapSettingsChanges = (0, _reselect.createSelector)(getMapSettings, getRollbackMapSettings, (settings, rollbackSettings) => {
  return rollbackSettings ? !_lodash.default.isEqual(settings, rollbackSettings) : false;
});
exports.hasMapSettingsChanges = hasMapSettingsChanges;
const getOpenTooltips = ({
  map
}) => {
  return map && map.openTooltips ? map.openTooltips : [];
};
exports.getOpenTooltips = getOpenTooltips;
const getHasLockedTooltips = state => {
  return getOpenTooltips(state).some(({
    isLocked
  }) => {
    return isLocked;
  });
};
exports.getHasLockedTooltips = getHasLockedTooltips;
const getMapReady = ({
  map
}) => map && map.ready;
exports.getMapReady = getMapReady;
const getMapInitError = ({
  map
}) => map.mapInitError;
exports.getMapInitError = getMapInitError;
const getGoto = ({
  map
}) => map && map.goto;
exports.getGoto = getGoto;
const getSelectedLayerId = ({
  map
}) => {
  return !map.selectedLayerId || !map.layerList ? null : map.selectedLayerId;
};
exports.getSelectedLayerId = getSelectedLayerId;
const getLayerListRaw = ({
  map
}) => map.layerList ? map.layerList : [];
exports.getLayerListRaw = getLayerListRaw;
const getWaitingForMapReadyLayerListRaw = ({
  map
}) => map.waitingForMapReadyLayerList ? map.waitingForMapReadyLayerList : [];
exports.getWaitingForMapReadyLayerListRaw = getWaitingForMapReadyLayerListRaw;
const getMapExtent = ({
  map
}) => map.mapState.extent;
exports.getMapExtent = getMapExtent;
const getMapBuffer = ({
  map
}) => map.mapState.buffer;
exports.getMapBuffer = getMapBuffer;
const getMapZoom = ({
  map
}) => map.mapState.zoom ? map.mapState.zoom : 0;
exports.getMapZoom = getMapZoom;
const getMapCenter = ({
  map
}) => map.mapState.center ? map.mapState.center : {
  lat: 0,
  lon: 0
};
exports.getMapCenter = getMapCenter;
const getMouseCoordinates = ({
  map
}) => map.mapState.mouseCoordinates;
exports.getMouseCoordinates = getMouseCoordinates;
const getTimeFilters = ({
  map
}) => map.mapState.timeFilters ? map.mapState.timeFilters : (0, _kibana_services.getTimeFilter)().getTime();
exports.getTimeFilters = getTimeFilters;
const getTimeslice = ({
  map
}) => map.mapState.timeslice;
exports.getTimeslice = getTimeslice;
const getCustomIcons = ({
  map
}) => {
  return map.settings.customIcons;
};
exports.getCustomIcons = getCustomIcons;
const getQuery = ({
  map
}) => map.mapState.query;
exports.getQuery = getQuery;
const getFilters = ({
  map
}) => map.mapState.filters;
exports.getFilters = getFilters;
const getEmbeddableSearchContext = ({
  map
}) => map.mapState.embeddableSearchContext;
exports.getEmbeddableSearchContext = getEmbeddableSearchContext;
const getSearchSessionId = ({
  map
}) => map.mapState.searchSessionId;
exports.getSearchSessionId = getSearchSessionId;
const getSearchSessionMapBuffer = ({
  map
}) => map.mapState.searchSessionMapBuffer;
exports.getSearchSessionMapBuffer = getSearchSessionMapBuffer;
const isUsingSearch = state => {
  const filters = getFilters(state).filter(filter => !filter.meta.disabled);
  const queryString = _lodash.default.get(getQuery(state), 'query', '');
  return !!filters.length || !!queryString.length;
};
exports.isUsingSearch = isUsingSearch;
const getDrawState = ({
  map
}) => map.mapState.drawState;
exports.getDrawState = getDrawState;
const getEditState = ({
  map
}) => map.mapState.editState;
exports.getEditState = getEditState;
function getLayerDescriptor(state, layerId) {
  const layerListRaw = getLayerListRaw(state);
  return layerListRaw.find(layer => layer.id === layerId);
}
function getDataRequestDescriptor(state, layerId, dataId) {
  const layerDescriptor = getLayerDescriptor(state, layerId);
  if (!layerDescriptor || !layerDescriptor.__dataRequests) {
    return;
  }
  return layerDescriptor.__dataRequests.find(dataRequest => {
    return dataRequest.dataId === dataId;
  });
}
function getExecutionContext(state) {
  return state.map.executionContext;
}
const getDataFilters = (0, _reselect.createSelector)(getMapExtent, getMapBuffer, getMapZoom, getTimeFilters, getTimeslice, getQuery, getFilters, getEmbeddableSearchContext, getSearchSessionId, getSearchSessionMapBuffer, _ui_selectors.getIsReadOnly, getExecutionContext, (mapExtent, mapBuffer, mapZoom, timeFilters, timeslice, query, filters, embeddableSearchContext, searchSessionId, searchSessionMapBuffer, isReadOnly, executionContext) => {
  return {
    extent: mapExtent,
    buffer: searchSessionId && searchSessionMapBuffer ? searchSessionMapBuffer : mapBuffer,
    zoom: mapZoom,
    timeFilters,
    timeslice,
    query,
    filters,
    embeddableSearchContext,
    searchSessionId,
    isReadOnly,
    executionContext
  };
});
exports.getDataFilters = getDataFilters;
const getSpatialFiltersLayer = (0, _reselect.createSelector)(getFilters, getEmbeddableSearchContext, getMapSettings, (filters, embeddableSearchContext, settings) => {
  var _embeddableSearchCont;
  const featureCollection = {
    type: 'FeatureCollection',
    features: (0, _elasticsearch_util.extractFeaturesFromFilters)([...filters, ...((_embeddableSearchCont = embeddableSearchContext === null || embeddableSearchContext === void 0 ? void 0 : embeddableSearchContext.filters) !== null && _embeddableSearchCont !== void 0 ? _embeddableSearchCont : [])])
  };
  const geoJsonSourceDescriptor = _geojson_file_source.GeoJsonFileSource.createDescriptor({
    __featureCollection: featureCollection,
    name: 'spatialFilters'
  });
  return new _vector_layer.GeoJsonVectorLayer({
    layerDescriptor: _vector_layer.GeoJsonVectorLayer.createDescriptor({
      id: _constants.SPATIAL_FILTERS_LAYER_ID,
      visible: settings.showSpatialFilters,
      alpha: settings.spatialFiltersAlpa,
      __dataRequests: [{
        dataId: _constants.SOURCE_DATA_REQUEST_ID,
        data: featureCollection
      }],
      style: _vector_style.VectorStyle.createDescriptor({
        [_constants.VECTOR_STYLES.FILL_COLOR]: {
          type: _constants.STYLE_TYPE.STATIC,
          options: {
            color: settings.spatialFiltersFillColor
          }
        },
        [_constants.VECTOR_STYLES.LINE_COLOR]: {
          type: _constants.STYLE_TYPE.STATIC,
          options: {
            color: settings.spatialFiltersLineColor
          }
        }
      })
    }),
    source: new _geojson_file_source.GeoJsonFileSource(geoJsonSourceDescriptor),
    customIcons: [] // spatial filters layer does not support custom icons
  });
});
exports.getSpatialFiltersLayer = getSpatialFiltersLayer;
const getLayerList = (0, _reselect.createSelector)(getLayerListRaw, _non_serializable_instances.getChartsPaletteServiceGetColor, getCustomIcons, (layerDescriptorList, chartsPaletteServiceGetColor, customIcons) => {
  const layers = layerDescriptorList.map(layerDescriptor => createLayerInstance(layerDescriptor, customIcons, chartsPaletteServiceGetColor));
  const childrenMap = new Map();
  layers.forEach(layer => {
    const parent = layer.getParent();
    if (!parent) {
      return;
    }
    const children = childrenMap.has(parent) ? childrenMap.get(parent) : [];
    childrenMap.set(parent, [...children, layer]);
  });
  childrenMap.forEach((children, parent) => {
    const parentLayer = layers.find(layer => {
      return layer.getId() === parent;
    });
    if (!parentLayer || !(0, _layer_group.isLayerGroup)(parentLayer)) {
      return;
    }
    parentLayer.setChildren(children);
  });
  return layers;
});
exports.getLayerList = getLayerList;
const getLayerListConfigOnly = (0, _reselect.createSelector)(getLayerListRaw, layerDescriptorList => {
  return (0, _copy_persistent_state.copyPersistentState)(layerDescriptorList);
});
exports.getLayerListConfigOnly = getLayerListConfigOnly;
function getLayerById(layerId, state) {
  return getLayerList(state).find(layer => {
    return layerId === layer.getId();
  });
}
const getHiddenLayerIds = (0, _reselect.createSelector)(getLayerListRaw, layers => layers.filter(layer => !layer.visible).map(layer => layer.id));
exports.getHiddenLayerIds = getHiddenLayerIds;
const getSelectedLayer = (0, _reselect.createSelector)(getSelectedLayerId, getLayerList, (selectedLayerId, layerList) => {
  return layerList.find(layer => layer.getId() === selectedLayerId);
});
exports.getSelectedLayer = getSelectedLayer;
const hasPreviewLayers = (0, _reselect.createSelector)(getLayerList, layerList => {
  return layerList.some(layer => {
    return layer.isPreviewLayer();
  });
});
exports.hasPreviewLayers = hasPreviewLayers;
const getMapColors = (0, _reselect.createSelector)(getLayerListRaw, layerList => layerList.filter(layerDescriptor => {
  return !layerDescriptor.__isPreviewLayer;
}).reduce((accu, layerDescriptor) => {
  const color = _lodash.default.get(layerDescriptor, 'style.properties.fillColor.options.color');
  if (color) accu.push(color);
  return accu;
}, []));
exports.getMapColors = getMapColors;
const getSelectedLayerJoinDescriptors = (0, _reselect.createSelector)(getSelectedLayer, selectedLayer => {
  if (!selectedLayer || !('getJoins' in selectedLayer)) {
    return [];
  }
  return selectedLayer.getJoins().map(join => {
    return join.toDescriptor();
  });
});
exports.getSelectedLayerJoinDescriptors = getSelectedLayerJoinDescriptors;
const getQueryableUniqueIndexPatternIds = (0, _reselect.createSelector)(getLayerList, getWaitingForMapReadyLayerListRaw, (layerList, waitingForMapReadyLayerList) => {
  const indexPatternIds = [];
  if (waitingForMapReadyLayerList.length) {
    waitingForMapReadyLayerList.forEach(layerDescriptor => {
      const layer = createLayerInstance(layerDescriptor, []); // custom icons not needed, layer instance only used to get index pattern ids
      if (layer.isVisible()) {
        indexPatternIds.push(...layer.getQueryableIndexPatternIds());
      }
    });
  } else {
    layerList.forEach(layer => {
      if (layer.isVisible()) {
        indexPatternIds.push(...layer.getQueryableIndexPatternIds());
      }
    });
  }
  return _lodash.default.uniq(indexPatternIds);
});
exports.getQueryableUniqueIndexPatternIds = getQueryableUniqueIndexPatternIds;
const getGeoFieldNames = (0, _reselect.createSelector)(getLayerList, getWaitingForMapReadyLayerListRaw, (layerList, waitingForMapReadyLayerList) => {
  const geoFieldNames = [];
  if (waitingForMapReadyLayerList.length) {
    waitingForMapReadyLayerList.forEach(layerDescriptor => {
      const layer = createLayerInstance(layerDescriptor, []); // custom icons not needed, layer instance only used to get geo field names
      geoFieldNames.push(...layer.getGeoFieldNames());
    });
  } else {
    layerList.forEach(layer => {
      geoFieldNames.push(...layer.getGeoFieldNames());
    });
  }
  return _lodash.default.uniq(geoFieldNames);
});
exports.getGeoFieldNames = getGeoFieldNames;
const hasDirtyState = (0, _reselect.createSelector)(getLayerListRaw, layerListRaw => {
  return layerListRaw.some(layerDescriptor => {
    if (layerDescriptor.__isPreviewLayer) {
      return true;
    }
    const trackedState = layerDescriptor[_copy_persistent_state.TRACKED_LAYER_DESCRIPTOR];
    if (!trackedState) {
      return false;
    }
    const currentState = (0, _copy_persistent_state.copyPersistentState)(layerDescriptor);
    return !_lodash.default.isEqual(currentState, trackedState);
  });
});
exports.hasDirtyState = hasDirtyState;
const isMapLoading = (0, _reselect.createSelector)(getLayerList, getWaitingForMapReadyLayerListRaw, getMapZoom, (layerList, waitingForMapReadyLayerList, zoom) => {
  if (waitingForMapReadyLayerList.length) {
    return true;
  }
  for (let i = 0; i < layerList.length; i++) {
    const layer = layerList[i];
    if (!layer.hasErrors() && layer.isLayerLoading(zoom)) {
      return true;
    }
  }
  return false;
});
exports.isMapLoading = isMapLoading;