"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VectorTileAdapter = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _events = require("events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class VectorTileAdapter extends _events.EventEmitter {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_layers", {});
    (0, _defineProperty2.default)(this, "_tiles", []);
  }
  addLayer(layerId, label, tileUrl) {
    this._layers[layerId] = {
      label,
      tileUrl
    };
    this._onChange();
  }
  removeLayer(layerId) {
    delete this._layers[layerId];
    this._onChange();
  }
  hasLayers() {
    return Object.keys(this._layers).length > 0;
  }
  setTiles(tiles) {
    this._tiles = tiles;
    this._onChange();
  }
  getLayerOptions() {
    return Object.keys(this._layers).map(layerId => {
      return {
        value: layerId,
        label: this._layers[layerId].label
      };
    });
  }
  getTileRequests(layerId) {
    if (!this._layers[layerId]) {
      return [];
    }
    const {
      tileUrl
    } = this._layers[layerId];
    return this._tiles.map(tile => {
      return {
        layerId,
        tileUrl,
        ...tile
      };
    });
  }
  _onChange() {
    this.emit('change');
  }
}
exports.VectorTileAdapter = VectorTileAdapter;