"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolbarOverlay = void 0;
var _reactRedux = require("react-redux");
var _toolbar_overlay = require("./toolbar_overlay");
var _ui_selectors = require("../../selectors/ui_selectors");
var _map_selectors = require("../../selectors/map_selectors");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapStateToProps(state) {
  return {
    showToolsControl: (0, _map_selectors.getGeoFieldNames)(state).length !== 0,
    shapeDrawModeActive: (0, _ui_selectors.getDrawMode)(state) === _constants.DRAW_MODE.DRAW_SHAPES,
    pointDrawModeActive: (0, _ui_selectors.getDrawMode)(state) === _constants.DRAW_MODE.DRAW_POINTS
  };
}
const connected = (0, _reactRedux.connect)(mapStateToProps)(_toolbar_overlay.ToolbarOverlay);
exports.ToolbarOverlay = connected;