"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayerSettings = void 0;
var _reactRedux = require("react-redux");
var _layer_settings = require("./layer_settings");
var _actions = require("../../../actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapDispatchToProps(dispatch) {
  return {
    clearLayerAttribution: id => dispatch((0, _actions.clearLayerAttribution)(id)),
    setLayerAttribution: (id, attribution) => dispatch((0, _actions.setLayerAttribution)(id, attribution)),
    updateLabel: (id, label) => dispatch((0, _actions.updateLayerLabel)(id, label)),
    updateLocale: (id, locale) => dispatch((0, _actions.updateLayerLocale)(id, locale)),
    updateMinZoom: (id, minZoom) => dispatch((0, _actions.updateLayerMinZoom)(id, minZoom)),
    updateMaxZoom: (id, maxZoom) => dispatch((0, _actions.updateLayerMaxZoom)(id, maxZoom)),
    updateAlpha: (id, alpha) => dispatch((0, _actions.updateLayerAlpha)(id, alpha)),
    updateLabelsOnTop: (id, areLabelsOnTop) => dispatch((0, _actions.updateLabelsOnTop)(id, areLabelsOnTop)),
    updateIncludeInFitToBounds: (id, includeInFitToBounds) => dispatch((0, _actions.updateFittableFlag)(id, includeInFitToBounds)),
    updateDisableTooltips: (id, DisableTooltips) => dispatch((0, _actions.updateDisableTooltips)(id, DisableTooltips))
  };
}
const connectedLayerSettings = (0, _reactRedux.connect)(null, mapDispatchToProps)(_layer_settings.LayerSettings);
exports.LayerSettings = connectedLayerSettings;