"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttributionFormRow = AttributionFormRow;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _attribution_popover = require("./attribution_popover");
var _panel_strings = require("../../panel_strings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AttributionFormRow(props) {
  function renderAttribution() {
    const layerDescriptor = props.layer.getDescriptor();
    return /*#__PURE__*/_react.default.createElement("fieldset", {
      "aria-labelledby": "mapsLayerSettingsAttributionLegend"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "mapAttributionFormRow"
    }, /*#__PURE__*/_react.default.createElement("legend", {
      id: "mapsLayerSettingsAttributionLegend",
      className: "mapAttributionFormRow__legend"
    }, _i18n.i18n.translate('xpack.maps.layerSettings.attributionLegend', {
      defaultMessage: 'Attribution'
    })), layerDescriptor.attribution === undefined ? /*#__PURE__*/_react.default.createElement("div", {
      className: "mapAttributionFormRow__field"
    }, /*#__PURE__*/_react.default.createElement(_attribution_popover.AttributionPopover, {
      onChange: props.onChange,
      popoverButtonIcon: "plusInCircleFilled",
      popoverButtonLabel: _i18n.i18n.translate('xpack.maps.attribution.addBtnLabel', {
        defaultMessage: 'Add attribution'
      }),
      popoverButtonAriaLabel: _i18n.i18n.translate('xpack.maps.attribution.addBtnAriaLabel', {
        defaultMessage: 'Add attribution'
      }),
      popoverButtonClassName: "mapAttributionFormRow__addButton",
      label: '',
      url: ''
    })) : /*#__PURE__*/_react.default.createElement("div", {
      className: "mapAttributionFormRow__field"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      color: "subdued",
      paddingSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      color: "text",
      href: layerDescriptor.attribution.url,
      target: "_blank"
    }, layerDescriptor.attribution.label)), /*#__PURE__*/_react.default.createElement("div", {
      className: "mapAttributionFormRow__buttons"
    }, /*#__PURE__*/_react.default.createElement(_attribution_popover.AttributionPopover, {
      onChange: props.onChange,
      popoverButtonIcon: "pencil",
      popoverButtonAriaLabel: _i18n.i18n.translate('xpack.maps.attribution.editBtnAriaLabel', {
        defaultMessage: 'Edit attribution'
      }),
      popoverButtonLabel: _panel_strings.panelStrings.edit,
      label: layerDescriptor.attribution.label,
      url: layerDescriptor.attribution.url
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => {
        props.onChange();
      },
      size: "xs",
      iconType: "trash",
      color: "danger",
      "aria-label": _i18n.i18n.translate('xpack.maps.attribution.clearBtnAriaLabel', {
        defaultMessage: 'Clear attribution'
      })
    }, _panel_strings.panelStrings.clear)))));
  }
  return props.layer.getSource().getAttributionProvider() ? null : renderAttribution();
}