"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpatialJoinPopoverContent = SpatialJoinPopoverContent;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana_services = require("../../../../../kibana_services");
var _index_pattern_util = require("../../../../../index_pattern_util");
var _geo_index_pattern_select = require("../../../../../components/geo_index_pattern_select");
var _geo_field_select = require("../../../../../components/geo_field_select");
var _input_strings = require("../../../../input_strings");
var _spatial_join_wizard = require("../../../../../classes/layers/wizards/spatial_join_wizard");
var _join_sources = require("../../../../../classes/sources/join_sources");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SpatialJoinPopoverContent(props) {
  const [rightDataView, setRightDataView] = (0, _react.useState)(undefined);
  const [rightGeoFields, setRightGeoFields] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [unableToLoadDataView, setUnableToLoadDataView] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (props.sourceDescriptor.indexPatternId === undefined) {
      return;
    }
    let ignore = false;
    setIsLoading(true);
    (0, _kibana_services.getIndexPatternService)().get(props.sourceDescriptor.indexPatternId).then(dataView => {
      if (!ignore) {
        setIsLoading(false);
        setRightDataView(dataView);
        setRightGeoFields((0, _index_pattern_util.getGeoFields)(dataView.fields));
      }
    }).catch(err => {
      if (!ignore) {
        setIsLoading(false);
        setUnableToLoadDataView(true);
      }
    });
    return () => {
      ignore = true;
    };
    // only run on mount
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const dataViewCallout = unableToLoadDataView ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.maps.spatialJoinExpression.noDataViewTitle', {
    defaultMessage: 'Unable to load data view {dataViewId}.',
    values: {
      dataViewId: props.sourceDescriptor.indexPatternId
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })) : null;
  const geoFieldSelect = rightDataView ? /*#__PURE__*/_react.default.createElement(_geo_field_select.GeoFieldSelect, {
    value: props.sourceDescriptor.geoField ? props.sourceDescriptor.geoField : '',
    onChange: geoField => {
      if (!geoField) {
        return;
      }
      props.onSourceDescriptorChange({
        ...props.sourceDescriptor,
        geoField
      });
    },
    geoFields: rightGeoFields,
    isClearable: false
  }) : null;
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, _i18n.i18n.translate('xpack.maps.spatialJoinExpression.popoverTitle', {
    defaultMessage: 'Configure spatial join'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    isLoading: isLoading
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _input_strings.inputStrings.relationshipLabel
  }, /*#__PURE__*/_react.default.createElement(_spatial_join_wizard.RelationshipExpression, {
    distance: typeof props.sourceDescriptor.distance === 'number' ? props.sourceDescriptor.distance : _join_sources.DEFAULT_WITHIN_DISTANCE,
    onDistanceChange: distance => {
      props.onSourceDescriptorChange({
        ...props.sourceDescriptor,
        distance
      });
    }
  })), dataViewCallout, /*#__PURE__*/_react.default.createElement(_geo_index_pattern_select.GeoIndexPatternSelect, {
    dataView: rightDataView,
    onChange: dataView => {
      setUnableToLoadDataView(false);
      setRightDataView(dataView);
      const geoFields = (0, _index_pattern_util.getGeoFields)(dataView.fields);
      setRightGeoFields(geoFields);
      props.onSourceDescriptorChange({
        ...props.sourceDescriptor,
        indexPatternId: dataView.id,
        geoField: geoFields.length ? geoFields[0].name : undefined
      });
    }
  }), geoFieldSelect));
}