"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JoinEditor = JoinEditor;
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _join = require("./resources/join");
var _join_documentation_popover = require("./resources/join_documentation_popover");
var _constants = require("../../../../common/constants");
var _add_join_button = require("./add_join_button");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function JoinEditor({
  joins,
  layer,
  onChange,
  leftJoinFields,
  layerDisplayName
}) {
  const [supportsSpatialJoin, setSupportsSpatialJoin] = (0, _react.useState)(false);
  const [spatialJoinDisableReason, setSpatialJoinDisableReason] = (0, _react.useState)('');
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    let ignore = false;
    const source = layer.getSource();
    if (!source.isESSource()) {
      setSpatialJoinDisableReason(_i18n.i18n.translate('xpack.maps.layerPanel.joinEditor.spatialJoin.disabled.esSourceOnly', {
        defaultMessage: 'Spatial joins are not supported for {sourceType}.',
        values: {
          sourceType: source.getType()
        }
      }));
      setSupportsSpatialJoin(false);
      return;
    }
    if (source.isMvt()) {
      setSpatialJoinDisableReason(_i18n.i18n.translate('xpack.maps.layerPanel.joinEditor.spatialJoin.disabled.geoJsonOnly', {
        defaultMessage: 'Spatial joins are not supported with vector tiles.'
      }));
      setSupportsSpatialJoin(false);
      return;
    }

    // TODO remove isPointsOnly check once non-point spatial joins have been implemented
    setIsLoading(true);
    source.getSupportedShapeTypes().then(supportedShapes => {
      if (!ignore) {
        const isPointsOnly = supportedShapes.length === 1 && supportedShapes[0] === _constants.VECTOR_SHAPE_TYPE.POINT;
        if (!isPointsOnly) {
          setSpatialJoinDisableReason(_i18n.i18n.translate('xpack.maps.layerPanel.joinEditor.spatialJoin.disabled.pointsOnly', {
            defaultMessage: 'Spatial joins are not supported with geo_shape geometry.'
          }));
          setSupportsSpatialJoin(isPointsOnly);
          setIsLoading(false);
          return;
        }
        setSpatialJoinDisableReason('');
        setSupportsSpatialJoin(true);
        setIsLoading(false);
      }
    }).catch(error => {
      // keep spatial joins disabled when unable to verify if they are supported
    });
    return () => {
      ignore = true;
    };
  }, [layer]);
  const renderJoins = () => {
    return joins.map((joinDescriptor, index) => {
      var _joinDescriptor$right, _joinDescriptor$right2;
      const handleOnChange = updatedDescriptor => {
        onChange(layer, [...joins.slice(0, index), updatedDescriptor, ...joins.slice(index + 1)]);
      };
      const handleOnRemove = () => {
        onChange(layer, [...joins.slice(0, index), ...joins.slice(index + 1)]);
      };
      return /*#__PURE__*/_react.default.createElement(_join.Join, {
        key: (_joinDescriptor$right = joinDescriptor === null || joinDescriptor === void 0 ? void 0 : (_joinDescriptor$right2 = joinDescriptor.right) === null || _joinDescriptor$right2 === void 0 ? void 0 : _joinDescriptor$right2.id) !== null && _joinDescriptor$right !== void 0 ? _joinDescriptor$right : index,
        join: joinDescriptor,
        onChange: handleOnChange,
        onRemove: handleOnRemove,
        leftFields: leftJoinFields,
        leftSourceName: layerDisplayName
      });
    });
  };
  const addJoin = joinDescriptor => {
    var _joinDescriptor$right3;
    onChange(layer, [...joins, {
      ...joinDescriptor,
      right: {
        ...((_joinDescriptor$right3 = joinDescriptor === null || joinDescriptor === void 0 ? void 0 : joinDescriptor.right) !== null && _joinDescriptor$right3 !== void 0 ? _joinDescriptor$right3 : {})
      }
    }]);
  };
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.layerPanel.joinEditor.title",
    defaultMessage: "Joins"
  }), ' ', /*#__PURE__*/_react.default.createElement(_join_documentation_popover.JoinDocumentationPopover, null))), renderJoins(), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 1,
    isLoading: isLoading
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement(_add_join_button.AddJoinButton, {
    disabledReason: spatialJoinDisableReason,
    isDisabled: !supportsSpatialJoin,
    label: _i18n.i18n.translate('xpack.maps.layerPanel.joinEditor.spatialJoin.addButtonLabel', {
      defaultMessage: 'Add spatial join'
    }),
    onClick: () => {
      addJoin({
        leftField: '_id',
        right: {
          type: _constants.SOURCE_TYPES.ES_DISTANCE_SOURCE,
          id: (0, _uuid.v4)(),
          applyGlobalQuery: true,
          applyGlobalTime: true
        }
      });
    }
  }), /*#__PURE__*/_react.default.createElement(_add_join_button.AddJoinButton, {
    disabledReason: _i18n.i18n.translate('xpack.maps.layerPanel.joinEditor.termJoin.mvtSingleJoinMsg', {
      defaultMessage: 'Vector tiles can only support a single join.'
    }),
    isDisabled: layer.getSource().isMvt() && joins.length >= 1,
    label: _i18n.i18n.translate('xpack.maps.layerPanel.joinEditor.termJoin.addButtonLabel', {
      defaultMessage: 'Add term join'
    }),
    onClick: () => {
      addJoin({
        right: {
          type: _constants.SOURCE_TYPES.ES_TERM_SOURCE,
          id: (0, _uuid.v4)(),
          applyGlobalQuery: true,
          applyGlobalTime: true
        }
      });
    }
  }))));
}