"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoIndexPatternSelect = GeoIndexPatternSelect;
var _react = _interopRequireWildcard(require("react"));
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/data-plugin/public");
var _kibana_services = require("../kibana_services");
var _i18n_getters = require("../../common/i18n_getters");
var _constants = require("../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function GeoIndexPatternSelect(props) {
  var _props$dataView;
  const [noDataViews, setNoDataViews] = (0, _react.useState)(false);
  const hasGeoFields = (0, _react.useMemo)(() => {
    return props.dataView ? props.dataView.fields.some(field => {
      return !_public.indexPatterns.isNestedField(field) && props !== null && props !== void 0 && props.isGeoPointsOnly ? _constants.ES_GEO_FIELD_TYPE.GEO_POINT === field.type : _constants.ES_GEO_FIELD_TYPES.includes(field.type);
    }) : false;
  }, [props.dataView, props === null || props === void 0 ? void 0 : props.isGeoPointsOnly]);
  const isMounted = (0, _useMountedState.default)();
  const dataViewIdRef = (0, _react.useRef)();
  async function _onIndexPatternSelect(indexPatternId) {
    if (!indexPatternId || indexPatternId.length === 0) {
      return;
    }
    dataViewIdRef.current = indexPatternId;
    let indexPattern;
    try {
      indexPattern = await (0, _kibana_services.getIndexPatternService)().get(indexPatternId);
    } catch (err) {
      return;
    }

    // method may be called again before 'get' returns
    // ignore response when fetched index pattern does not match active index pattern
    if (isMounted() && indexPattern.id === dataViewIdRef.current) {
      props.onChange(indexPattern);
    }
  }
  function _renderNoIndexPatternWarning() {
    if (!noDataViews) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.maps.noIndexPattern.messageTitle', {
        defaultMessage: `Couldn't find any data views`
      }),
      color: "warning"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.noIndexPattern.doThisPrefixDescription",
      defaultMessage: "You'll need to "
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: (0, _kibana_services.getHttp)().basePath.prepend(`/app/management/kibana/dataViews`)
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.noIndexPattern.doThisLinkTextDescription",
      defaultMessage: "Create a data view."
    }))), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.noIndexPattern.hintDescription",
      defaultMessage: "Don't have any data? "
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: (0, _kibana_services.getHttp)().basePath.prepend('/app/home#/tutorial_directory/sampleData')
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.noIndexPattern.getStartedLinkText",
      defaultMessage: "Get started with some sample data sets."
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }
  const IndexPatternSelect = (0, _kibana_services.getIndexPatternSelectComponent)();
  const isDataViewInvalid = !props.dataView ? false : !hasGeoFields;
  const error = isDataViewInvalid ? _i18n.i18n.translate('xpack.maps.noGeoFieldInIndexPattern.message', {
    defaultMessage: 'Data view does not contain any geospatial fields'
  }) : '';
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _renderNoIndexPatternWarning(), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: (0, _i18n_getters.getDataViewLabel)(),
    isInvalid: isDataViewInvalid,
    error: error
  }, /*#__PURE__*/_react.default.createElement(IndexPatternSelect, {
    isInvalid: isDataViewInvalid,
    isDisabled: noDataViews,
    indexPatternId: (_props$dataView = props.dataView) !== null && _props$dataView !== void 0 && _props$dataView.id ? props.dataView.id : '',
    onChange: _onIndexPatternSelect,
    placeholder: (0, _i18n_getters.getDataViewSelectPlaceholder)(),
    onNoIndexPatterns: () => {
      setNoDataViews(true);
    },
    isClearable: false,
    "data-test-subj": "mapGeoIndexPatternSelect"
  })));
}