"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomIconModal = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _analytics = require("@kbn/analytics");
var _i18n = require("@kbn/i18n");
var _icon_preview = require("./icon_preview");
var _symbol_utils = require("../../symbol_utils");
var _validated_range = require("../../../../../components/validated_range");
var _common = require("../../../../../../common");
var _kibana_services = require("../../../../../kibana_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getAdvancedOptionsLabel: () => _i18n.i18n.translate('xpack.maps.customIconModal.advancedOptionsLabel', {
    defaultMessage: 'Advanced options'
  }),
  getCancelButtonLabel: () => _i18n.i18n.translate('xpack.maps.customIconModal.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  }),
  getCutoffRangeLabel: () => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.maps.customIconModal.cutoffRangeTooltip', {
      defaultMessage: 'Adjusts the balance of the signed distance function between the inside (approaching 1) and outside (approaching 0) of the icon.'
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.maps.customIconModal.cutoffRangeLabel', {
    defaultMessage: 'Alpha threshold'
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "subdued",
    type: "questionInCircle"
  }))),
  getDeleteButtonLabel: () => _i18n.i18n.translate('xpack.maps.customIconModal.deleteButtonLabel', {
    defaultMessage: 'Delete'
  }),
  getImageFilePickerPlaceholder: () => _i18n.i18n.translate('xpack.maps.customIconModal.imageFilePickerPlaceholder', {
    defaultMessage: 'Select or drag and drop an SVG icon'
  }),
  getImageInputDescription: () => _i18n.i18n.translate('xpack.maps.customIconModal.imageInputDescription', {
    defaultMessage: 'SVGs without sharp corners and intricate details work best. Modifying the settings under Advanced options may improve rendering.'
  }),
  getInvalidFileLabel: () => _i18n.i18n.translate('xpack.maps.customIconModal.invalidFileError', {
    defaultMessage: 'Icon must be in SVG format. Other image types are not supported.'
  }),
  getNameInputLabel: () => _i18n.i18n.translate('xpack.maps.customIconModal.nameInputLabel', {
    defaultMessage: 'Name'
  }),
  getRadiusRangeLabel: () => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.maps.customIconModal.raduisRangeTooltip', {
      defaultMessage: 'Adjusts the size of the signed distance function around the Alpha threshold as a percent of icon size.'
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.maps.customIconModal.radiusRangeLabel', {
    defaultMessage: 'Radius'
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "subdued",
    type: "questionInCircle"
  }))),
  getResetButtonLabel: () => _i18n.i18n.translate('xpack.maps.customIconModal.resetButtonLabel', {
    defaultMessage: 'Reset'
  }),
  getSaveButtonLabel: () => _i18n.i18n.translate('xpack.maps.customIconModal.saveButtonLabel', {
    defaultMessage: 'Save'
  })
};
function getFileNameWithoutExt(fileName) {
  const splits = fileName.split('.');
  if (splits.length > 1) {
    splits.pop();
  }
  return splits.join('.');
}
class CustomIconModal extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      label: this.props.label || '',
      svg: this.props.svg || '',
      cutoff: this.props.cutoff,
      radius: this.props.radius,
      isFileInvalid: this.props.svg ? false : true
    });
    (0, _defineProperty2.default)(this, "_handleLabelChange", value => {
      this.setState({
        label: value
      });
    });
    (0, _defineProperty2.default)(this, "_handleCutoffChange", value => {
      this.setState({
        cutoff: value
      });
    });
    (0, _defineProperty2.default)(this, "_handleRadiusChange", value => {
      this.setState({
        radius: value
      });
    });
    (0, _defineProperty2.default)(this, "_resetAdvancedOptions", () => {
      this.setState({
        radius: this.props.radius,
        cutoff: this.props.cutoff
      });
    });
    (0, _defineProperty2.default)(this, "_onFileSelect", async files => {
      this.setState({
        label: '',
        svg: '',
        isFileInvalid: false
      });
      if (files && files.length) {
        const file = files[0];
        const {
          type
        } = file;
        if (type === 'image/svg+xml') {
          var _this$props$label;
          const label = (_this$props$label = this.props.label) !== null && _this$props$label !== void 0 ? _this$props$label : getFileNameWithoutExt(file.name);
          try {
            const svg = await file.text();
            if (!this._isMounted) {
              return;
            }
            this.setState({
              isFileInvalid: false,
              label,
              svg
            });
          } catch (err) {
            if (!this._isMounted) {
              return;
            }
            this.setState({
              isFileInvalid: true
            });
          }
        } else {
          this.setState({
            isFileInvalid: true
          });
        }
      }
    });
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  componentDidMount() {
    this._isMounted = true;
  }
  _renderAdvancedOptions() {
    const {
      cutoff,
      radius
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: "advancedOptionsAccordion",
      buttonContent: strings.getAdvancedOptionsLabel(),
      paddingSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      color: "subdued",
      paddingSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      onClick: this._resetAdvancedOptions
    }, strings.getResetButtonLabel()))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      className: "mapsCustomIconForm__cutoff",
      label: strings.getCutoffRangeLabel(),
      display: "rowCompressed"
    }, /*#__PURE__*/_react.default.createElement(_validated_range.ValidatedRange, {
      min: 0,
      max: 1,
      value: cutoff,
      step: 0.01,
      showInput: true,
      showLabels: true,
      compressed: true,
      className: "mapsCutoffRange",
      onChange: this._handleCutoffChange
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      className: "mapsCustomIconForm__radius",
      label: strings.getRadiusRangeLabel(),
      display: "rowCompressed"
    }, /*#__PURE__*/_react.default.createElement(_validated_range.ValidatedRange, {
      min: 0,
      max: 1,
      value: radius,
      step: 0.01,
      showInput: true,
      showLabels: true,
      compressed: true,
      className: "mapsRadiusRange",
      onChange: this._handleRadiusChange
    }))));
  }
  _renderIconForm() {
    const {
      label,
      svg
    } = this.state;
    return svg !== '' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: strings.getNameInputLabel(),
      display: "rowCompressed"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: label,
      className: "mapsCustomIconForm__label",
      onChange: e => this._handleLabelChange(e.target.value),
      required: true,
      "data-test-subj": "mapsCustomIconForm-label"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), this._renderAdvancedOptions()) : null;
  }
  _renderIconPreview() {
    const {
      svg,
      isFileInvalid,
      cutoff,
      radius
    } = this.state;
    return svg !== '' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "mapsIconPreview__wrapper mapsCustomIconForm__preview",
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_icon_preview.IconPreview, {
      svg: svg,
      isSvgInvalid: isFileInvalid,
      cutoff: cutoff,
      radius: radius
    })) : null;
  }
  render() {
    const usageCollector = (0, _kibana_services.getUsageCollection)();
    const {
      symbolId,
      onSave,
      onCancel,
      onDelete,
      title
    } = this.props;
    const {
      label,
      svg,
      cutoff,
      radius,
      isFileInvalid
    } = this.state;
    const isComplete = label.length !== 0 && svg.length !== 0 && !isFileInvalid;
    const fileError = svg && isFileInvalid ? strings.getInvalidFileLabel() : '';
    return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      className: "mapsCustomIconModal",
      maxWidth: 700,
      onClose: onCancel,
      initialFocus: ".mapsCustomIconForm__image"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
      component: "h3"
    }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "flexStart",
      gutterSize: "m"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "mapsCustomIconForm",
      grow: 2
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      className: "mapsCustomIconForm__image",
      display: "rowCompressed",
      isInvalid: !!fileError,
      error: fileError,
      helpText: strings.getImageInputDescription()
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
      initialPromptText: strings.getImageFilePickerPlaceholder(),
      onChange: this._onFileSelect,
      className: "mapsImageUpload",
      accept: ".svg",
      isInvalid: !!fileError,
      required: true
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), this._renderIconForm()), this._renderIconPreview())), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: onCancel
    }, strings.getCancelButtonLabel())), onDelete && symbolId ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "danger",
      onClick: () => {
        usageCollector === null || usageCollector === void 0 ? void 0 : usageCollector.reportUiCounter(_common.APP_ID, _analytics.METRIC_TYPE.CLICK, 'settings_custom_icons_delete');
        onDelete(symbolId);
      },
      "data-test-subj": "mapsCustomIconForm-submit"
    }, strings.getDeleteButtonLabel())) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      onClick: () => {
        if (!onDelete) {
          // Only report events when adding a new custom icon, not when editing an existing icon
          usageCollector === null || usageCollector === void 0 ? void 0 : usageCollector.reportUiCounter(_common.APP_ID, _analytics.METRIC_TYPE.CLICK, 'settings_custom_icons_add');
        }
        onSave({
          symbolId: symbolId !== null && symbolId !== void 0 ? symbolId : (0, _symbol_utils.getCustomIconId)(),
          label,
          svg,
          cutoff,
          radius
        });
      },
      "data-test-subj": "mapsCustomIconForm-submit",
      isDisabled: !isComplete
    }, strings.getSaveButtonLabel())))));
  }
}
exports.CustomIconModal = CustomIconModal;