"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DynamicSizeForm = DynamicSizeForm;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _field_select = require("../field_select");
var _size_range_selector = require("./size_range_selector");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DynamicSizeForm({
  fields,
  onDynamicStyleChange,
  staticDynamicSelect,
  styleProperty
}) {
  const styleOptions = styleProperty.getOptions();
  const onFieldChange = ({
    field
  }) => {
    if (field) {
      onDynamicStyleChange(styleProperty.getStyleName(), {
        ...styleOptions,
        field: {
          name: field.name,
          origin: field.origin
        }
      });
    }
  };
  const onSizeRangeChange = ({
    minSize,
    maxSize
  }) => {
    onDynamicStyleChange(styleProperty.getStyleName(), {
      ...styleOptions,
      minSize,
      maxSize
    });
  };
  const onInvertChange = event => {
    onDynamicStyleChange(styleProperty.getStyleName(), {
      ...styleOptions,
      invert: event.target.checked
    });
  };
  let sizeRange;
  if (styleOptions.field && styleOptions.field.name) {
    sizeRange = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_size_range_selector.SizeRangeSelector, {
      onChange: onSizeRangeChange,
      minSize: styleOptions.minSize,
      maxSize: styleOptions.maxSize,
      showLabels: true,
      compressed: true
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "columnCompressedSwitch"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: _i18n.i18n.translate('xpack.maps.style.revereseSizeLabel', {
        defaultMessage: `Reverse size`
      }),
      checked: !!styleOptions.invert,
      onChange: onInvertChange,
      compressed: true
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "mapStyleSettings__fixedBox"
  }, staticDynamicSelect), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_field_select.FieldSelect, {
    styleName: styleProperty.getStyleName(),
    fields: fields,
    selectedFieldName: styleProperty.getFieldName(),
    onChange: onFieldChange,
    compressed: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), sizeRange);
}