"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MVTSingleLayerSourceSettings = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = _interopRequireDefault(require("lodash"));
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../../common/constants");
var _mvt_field_config_editor = require("./mvt_field_config_editor");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @typescript-eslint/consistent-type-definitions */

class MVTSingleLayerSourceSettings extends _react.Component {
  constructor(...args) {
    super(...args);
    // Tracking in state to allow for debounce.
    // Changes to layer-name and/or min/max zoom require heavy operation at map-level (removing and re-adding all sources/layers)
    // To preserve snappyness of typing, debounce the dispatches.
    (0, _defineProperty2.default)(this, "state", {
      currentLayerName: this.props.layerName,
      currentMinSourceZoom: this.props.minSourceZoom,
      currentMaxSourceZoom: this.props.maxSourceZoom,
      currentFields: _lodash.default.cloneDeep(this.props.fields)
    });
    (0, _defineProperty2.default)(this, "_handleChange", _lodash.default.debounce(() => {
      this.props.handleChange({
        layerName: this.state.currentLayerName,
        minSourceZoom: this.state.currentMinSourceZoom,
        maxSourceZoom: this.state.currentMaxSourceZoom,
        fields: this.state.currentFields
      });
    }, 200));
    (0, _defineProperty2.default)(this, "_handleLayerNameInputChange", e => {
      this.setState({
        currentLayerName: e.target.value
      }, this._handleChange);
    });
    (0, _defineProperty2.default)(this, "_handleFieldChange", fields => {
      this.setState({
        currentFields: fields
      }, this._handleChange);
    });
    (0, _defineProperty2.default)(this, "_handleZoomRangeChange", e => {
      this.setState({
        currentMinSourceZoom: parseInt(e[0], 10),
        currentMaxSourceZoom: parseInt(e[1], 10)
      }, this._handleChange);
    });
  }
  render() {
    const preMessage = _i18n.i18n.translate('xpack.maps.source.MVTSingleLayerVectorSourceEditor.fieldsPreHelpMessage', {
      defaultMessage: 'Fields which are available in '
    });
    const message = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("b", null, this.state.currentLayerName), ".", ' ');
    const postMessage = _i18n.i18n.translate('xpack.maps.source.MVTSingleLayerVectorSourceEditor.fieldsPostHelpMessage', {
      defaultMessage: 'These can be used for tooltips and dynamic styling.'
    });
    const fieldEditor = this.props.showFields && this.state.currentLayerName !== '' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        anchorClassName: "eui-alignMiddle",
        content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, preMessage, message, postMessage)
      }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.maps.source.MVTSingleLayerVectorSourceEditor.fieldsMessage', {
        defaultMessage: 'Fields'
      }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "questionInCircle",
        color: "subdued"
      })))
    }, /*#__PURE__*/_react.default.createElement(_mvt_field_config_editor.MVTFieldConfigEditor, {
      fields: this.state.currentFields.slice(),
      onChange: this._handleFieldChange
    })) : null;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "columnCompressed",
      label: _i18n.i18n.translate('xpack.maps.source.MVTSingleLayerVectorSourceEditor.layerNameMessage', {
        defaultMessage: 'Source layer'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: this.state.currentLayerName,
      onChange: this._handleLayerNameInputChange,
      isInvalid: this.state.currentLayerName === '',
      compressed: true
    })), /*#__PURE__*/_react.default.createElement(_public.ValidatedDualRange, {
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        anchorClassName: "eui-alignMiddle",
        content: _i18n.i18n.translate('xpack.maps.source.MVTSingleLayerVectorSourceEditor.zoomRangeHelpMessage', {
          defaultMessage: 'Zoom levels where the layer is present in the tiles. This does not correspond directly to visibility. Layer data from lower levels can always be displayed at higher zoom levels (but not vice versa).'
        })
      }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.maps.source.MVTSingleLayerVectorSourceEditor.zoomRangeTopMessage', {
        defaultMessage: 'Available levels'
      }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "questionInCircle",
        color: "subdued"
      }))),
      formRowDisplay: "columnCompressed",
      value: [this.state.currentMinSourceZoom, this.state.currentMaxSourceZoom],
      min: _constants.MIN_ZOOM,
      max: _constants.MAX_ZOOM,
      onChange: this._handleZoomRangeChange,
      allowEmptyRange: false,
      showInput: "inputWithPopover",
      compressed: true,
      showLabels: true,
      prepend: _i18n.i18n.translate('xpack.maps.source.MVTSingleLayerVectorSourceEditor.dataZoomRangeMessage', {
        defaultMessage: 'Zoom'
      })
    }), fieldEditor);
  }
}
exports.MVTSingleLayerSourceSettings = MVTSingleLayerSourceSettings;