"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToLines = convertToLines;
var _lodash = _interopRequireDefault(require("lodash"));
var _elasticsearch_util = require("../../../../common/elasticsearch_util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LAT_INDEX = 0;
const LON_INDEX = 1;
const PEW_PEW_BUCKET_KEYS_TO_IGNORE = ['key', 'sourceCentroid'];
function parsePointFromKey(key) {
  const split = key.split(',');
  const lat = parseFloat(split[LAT_INDEX]);
  const lon = parseFloat(split[LON_INDEX]);
  return [lon, lat];
}
function convertToLines(esResponse) {
  const lineFeatures = [];
  const destBuckets = _lodash.default.get(esResponse, 'aggregations.destSplit.buckets', []);
  for (let i = 0; i < destBuckets.length; i++) {
    const destBucket = destBuckets[i];
    const dest = parsePointFromKey(destBucket.key);
    const sourceBuckets = _lodash.default.get(destBucket, 'sourceGrid.buckets', []);
    for (let j = 0; j < sourceBuckets.length; j++) {
      const sourceBucket = sourceBuckets[j];
      const sourceCentroid = sourceBucket.sourceCentroid;
      lineFeatures.push({
        type: 'Feature',
        geometry: {
          type: 'LineString',
          coordinates: [[sourceCentroid.location.lon, sourceCentroid.location.lat], dest]
        },
        id: `${dest.join()},${sourceBucket.key}`,
        properties: (0, _elasticsearch_util.extractPropertiesFromBucket)(sourceBucket, PEW_PEW_BUCKET_KEYS_TO_IGNORE)
      });
    }
  }
  return {
    featureCollection: {
      type: 'FeatureCollection',
      features: lineFeatures
    }
  };
}