"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateSourceEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _geo_index_pattern_select = require("../../../components/geo_index_pattern_select");
var _geo_field_select = require("../../../components/geo_field_select");
var _index_pattern_util = require("../../../index_pattern_util");
var _geo_line_form = require("./geo_line_form");
var _constants = require("./constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CreateSourceEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      indexPattern: null,
      pointFields: [],
      geoField: '',
      groupByTimeseries: false,
      splitField: '',
      sortField: '',
      lineSimplificationSize: _constants.DEFAULT_LINE_SIMPLIFICATION_SIZE
    });
    (0, _defineProperty2.default)(this, "_onIndexPatternSelect", indexPattern => {
      const pointFields = (0, _index_pattern_util.getGeoPointFields)(indexPattern.fields);
      this.setState({
        indexPattern,
        pointFields,
        groupByTimeseries: (0, _index_pattern_util.getIsTimeseries)(indexPattern),
        geoField: pointFields.length ? pointFields[0].name : '',
        sortField: indexPattern.timeFieldName ? indexPattern.timeFieldName : ''
      }, this.previewLayer);
    });
    (0, _defineProperty2.default)(this, "_onGeoFieldSelect", geoField => {
      if (geoField === undefined) {
        return;
      }
      this.setState({
        geoField
      }, this.previewLayer);
    });
    (0, _defineProperty2.default)(this, "_onGroupByTimeseriesChange", groupByTimeseries => {
      this.setState({
        groupByTimeseries
      }, this.previewLayer);
    });
    (0, _defineProperty2.default)(this, "_onLineSimplificationSizeChange", lineSimplificationSize => {
      this.setState({
        lineSimplificationSize
      }, this.previewLayer);
    });
    (0, _defineProperty2.default)(this, "_onSplitFieldSelect", newValue => {
      this.setState({
        splitField: newValue
      }, this.previewLayer);
    });
    (0, _defineProperty2.default)(this, "_onSortFieldSelect", newValue => {
      this.setState({
        sortField: newValue
      }, this.previewLayer);
    });
    (0, _defineProperty2.default)(this, "previewLayer", () => {
      const {
        indexPattern,
        geoField,
        groupByTimeseries,
        splitField,
        sortField,
        lineSimplificationSize
      } = this.state;
      const sourceConfig = indexPattern && indexPattern.id && geoField && (groupByTimeseries || splitField && sortField) ? {
        indexPatternId: indexPattern.id,
        geoField,
        groupByTimeseries,
        lineSimplificationSize,
        splitField,
        sortField
      } : null;
      this.props.onSourceConfigChange(sourceConfig);
    });
  }
  _renderGeoSelect() {
    if (!this.state.indexPattern) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_geo_field_select.GeoFieldSelect, {
      value: this.state.geoField,
      onChange: this._onGeoFieldSelect,
      geoFields: this.state.pointFields,
      isClearable: false
    });
  }
  _renderGeoLineForm() {
    if (!this.state.indexPattern || !this.state.geoField) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_geo_line_form.GeoLineForm, {
      isColumnCompressed: false,
      indexPattern: this.state.indexPattern,
      onGroupByTimeseriesChange: this._onGroupByTimeseriesChange,
      onLineSimplificationSizeChange: this._onLineSimplificationSizeChange,
      onSortFieldChange: this._onSortFieldSelect,
      onSplitFieldChange: this._onSplitFieldSelect,
      groupByTimeseries: this.state.groupByTimeseries,
      lineSimplificationSize: this.state.lineSimplificationSize,
      sortField: this.state.sortField,
      splitField: this.state.splitField
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_geo_index_pattern_select.GeoIndexPatternSelect, {
      dataView: this.state.indexPattern,
      onChange: this._onIndexPatternSelect,
      isGeoPointsOnly: true
    }), this._renderGeoSelect(), this._renderGeoLineForm());
  }
}
exports.CreateSourceEditor = CreateSourceEditor;