"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateSourceEditor = UpdateSourceEditor;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _tooltip_selector = require("../../../components/tooltip_selector");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function UpdateSourceEditor(props) {
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [fields, setFields] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    let ignore = false;
    setIsLoading(true);
    props.source.getFields().then(nextFields => {
      if (!ignore) {
        setFields(nextFields);
        setIsLoading(false);
      }
    }).catch(err => {
      if (!ignore) {
        // When a matching EMS-config cannot be found, the source already will have thrown errors during the data request.
        // This will propagate to the vector-layer and be displayed in the UX
        setIsLoading(false);
      }
    });
    return () => {
      ignore = true;
    };
    // only run onMount
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.emsSource.tooltipsTitle",
    defaultMessage: "Tooltip fields"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    isLoading: isLoading
  }, /*#__PURE__*/_react.default.createElement(_tooltip_selector.TooltipSelector, {
    tooltipFields: props.tooltipFields,
    onChange: selectedFieldNames => {
      props.onChange({
        propName: 'tooltipProperties',
        value: selectedFieldNames
      });
    },
    fields: fields
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
}