"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WizardForm = WizardForm;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _index_pattern_util = require("../../../../../index_pattern_util");
var _left_source_panel = require("./left_source_panel");
var _right_source_panel = require("./right_source_panel");
var _create_spatial_join_layer_descriptor = require("./create_spatial_join_layer_descriptor");
var _join_sources = require("../../../../sources/join_sources");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isLeftConfigComplete(leftDataView, leftGeoField) {
  return leftDataView !== undefined && leftDataView.id && leftGeoField !== undefined;
}
function isRightConfigComplete(rightDataView, rightGeoField) {
  return rightDataView !== undefined && rightDataView.id && rightGeoField !== undefined;
}
function WizardForm({
  previewLayers
}) {
  const [distance, setDistance] = (0, _react.useState)(_join_sources.DEFAULT_WITHIN_DISTANCE);
  const [leftDataView, setLeftDataView] = (0, _react.useState)();
  const [leftGeoFields, setLeftGeoFields] = (0, _react.useState)([]);
  const [leftGeoField, setLeftGeoField] = (0, _react.useState)();
  const [rightDataView, setRightDataView] = (0, _react.useState)();
  const [rightGeoFields, setRightGeoFields] = (0, _react.useState)([]);
  const [rightGeoField, setRightGeoField] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    if (!isLeftConfigComplete(leftDataView, leftGeoField) || !isRightConfigComplete(rightDataView, rightGeoField)) {
      previewLayers([]);
      return;
    }
    const layerDescriptor = (0, _create_spatial_join_layer_descriptor.createDistanceJoinLayerDescriptor)({
      distance,
      leftDataViewId: leftDataView.id,
      // leftDataView.id verified in isLeftConfigComplete
      leftGeoField: leftGeoField,
      // leftGeoField verified in isLeftConfigComplete
      rightDataViewId: rightDataView.id,
      // rightDataView.id verified in isRightConfigComplete
      rightGeoField: rightGeoField // rightGeoField verified in isRightConfigComplete
    });

    previewLayers([layerDescriptor]);
  }, [distance, leftDataView, leftGeoField, rightDataView, rightGeoField, previewLayers]);
  const rightSourcePanel = isLeftConfigComplete(leftDataView, leftGeoField) ? /*#__PURE__*/_react.default.createElement(_right_source_panel.RightSourcePanel, {
    dataView: rightDataView,
    distance: distance,
    geoField: rightGeoField,
    geoFields: rightGeoFields,
    onDataViewSelect: dataView => {
      setRightDataView(dataView);
      const geoFields = (0, _index_pattern_util.getGeoFields)(dataView.fields);
      setRightGeoFields(geoFields);
      setRightGeoField(geoFields.length ? geoFields[0].name : undefined);
    },
    onDistanceChange: setDistance,
    onGeoFieldSelect: setRightGeoField
  }) : null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_left_source_panel.LeftSourcePanel, {
    dataView: leftDataView,
    geoField: leftGeoField,
    geoFields: leftGeoFields,
    onDataViewSelect: dataView => {
      setLeftDataView(dataView);
      const geoFields = (0, _index_pattern_util.getGeoPointFields)(dataView.fields);
      setLeftGeoFields(geoFields);
      setLeftGeoField(geoFields.length ? geoFields[0].name : undefined);
    },
    onGeoFieldSelect: setLeftGeoField
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), rightSourcePanel);
}