"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPatternSelect = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _security_index_pattern_utils = require("./security_index_pattern_utils");
var _i18n_getters = require("../../../../../../common/i18n_getters");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class IndexPatternSelect extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      hasLoaded: false,
      options: []
    });
    (0, _defineProperty2.default)(this, "_onChange", event => {
      const targetOption = this.state.options.find(({
        value,
        text
      }) => {
        return event.target.value === value;
      });
      if (event.target.value === '' || !targetOption) {
        this.props.onChange(null);
        return;
      }
      this.props.onChange({
        // @ts-expect-error - avoid wrong "Property does not exist on type 'never'." compile error
        id: targetOption.value,
        // @ts-expect-error - avoid wrong "Property does not exist on type 'never'." compile error
        title: targetOption.text
      });
    });
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadOptions();
  }
  async _loadOptions() {
    const indexPatterns = await (0, _security_index_pattern_utils.getSecurityIndexPatterns)();
    if (!this._isMounted) {
      return;
    }
    this.setState({
      hasLoaded: true,
      options: [{
        value: '',
        text: ''
      }, ...indexPatterns.map(({
        id,
        title
      }) => {
        return {
          value: id,
          text: title
        };
      })]
    });
  }
  render() {
    if (!this.state.hasLoaded) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: (0, _i18n_getters.getDataViewLabel)()
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      options: this.state.options,
      value: this.props.value ? this.props.value : '',
      onChange: this._onChange
    }));
  }
}
exports.IndexPatternSelect = IndexPatternSelect;