"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogstashPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _lodash = require("lodash");
var _services = require("./services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */ // @ts-ignore
class LogstashPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "licenseSubscription", void 0);
    (0, _defineProperty2.default)(this, "capabilities$", new _rxjs.Subject());
  }
  setup(core, plugins) {
    const logstashLicense$ = plugins.licensing.license$.pipe((0, _operators.map)(license => new _services.LogstashLicenseService(license)));
    const managementApp = plugins.management.sections.section.ingest.registerApp({
      id: 'pipelines',
      title: _i18n.i18n.translate('xpack.logstash.managementSection.pipelinesTitle', {
        defaultMessage: 'Logstash Pipelines'
      }),
      order: 1,
      mount: async params => {
        const [coreStart] = await core.getStartServices();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        const isMonitoringEnabled = ('monitoring' in plugins);
        return renderApp(coreStart, params, isMonitoringEnabled, logstashLicense$);
      }
    });
    this.licenseSubscription = (0, _rxjs.combineLatest)([logstashLicense$, this.capabilities$]).subscribe(([license, capabilities]) => {
      const shouldShow = license.enableLinks && capabilities.management.ingest.pipelines === true;
      if (shouldShow) {
        managementApp.enable();
      } else {
        managementApp.disable();
      }
      if (plugins.home && shouldShow) {
        // Ensure that we don't register the feature more than once
        (0, _lodash.once)(() => {
          plugins.home.featureCatalogue.register({
            id: 'management_logstash',
            title: _i18n.i18n.translate('xpack.logstash.homeFeature.logstashPipelinesTitle', {
              defaultMessage: 'Logstash Pipelines'
            }),
            description: _i18n.i18n.translate('xpack.logstash.homeFeature.logstashPipelinesDescription', {
              defaultMessage: 'Create, delete, update, and clone data ingestion pipelines.'
            }),
            icon: 'pipelineApp',
            path: '/app/management/ingest/pipelines',
            showOnHomePage: false,
            category: 'admin'
          });
        });
      }
    });
  }
  start(core) {
    this.capabilities$.next(core.application.capabilities);
  }
  stop() {
    if (this.licenseSubscription) {
      this.licenseSubscription.unsubscribe();
    }
  }
}
exports.LogstashPlugin = LogstashPlugin;