"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ScrollableLogTextStreamView = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _common = require("@kbn/kibana-react-plugin/common");
var _handlers = require("../../../utils/handlers");
var _auto_sizer = require("../../auto_sizer");
var _empty_states = require("../../empty_states");
var _loading = require("../../loading");
var _item = require("./item");
var _column_headers = require("./column_headers");
var _loading_item_view = require("./loading_item_view");
var _jump_to_tail = require("./jump_to_tail");
var _log_entry_row = require("./log_entry_row");
var _measurable_item_view = require("./measurable_item_view");
var _vertical_scroll_panel = require("./vertical_scroll_panel");
var _log_entry_column = require("./log_entry_column");
var _log_date_row = require("./log_date_row");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ScrollableLogTextStreamView extends _react.default.PureComponent {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "handleOpenFlyout", id => {
      var _this$props$onOpenLog, _this$props;
      (_this$props$onOpenLog = (_this$props = this.props).onOpenLogEntryFlyout) === null || _this$props$onOpenLog === void 0 ? void 0 : _this$props$onOpenLog.call(_this$props, id);
    });
    (0, _defineProperty2.default)(this, "handleOpenViewLogInContext", entry => {
      const {
        setContextEntry
      } = this.props;
      if (setContextEntry) {
        setContextEntry(entry);
      }
    });
    (0, _defineProperty2.default)(this, "handleReload", () => {
      const {
        reloadItems
      } = this.props;
      if (reloadItems) {
        reloadItems();
      }
    });
    (0, _defineProperty2.default)(this, "handleVisibleChildrenChange", (0, _handlers.callWithoutRepeats)(({
      topChild,
      middleChild,
      bottomChild,
      pagesAbove,
      pagesBelow,
      fromScroll
    }) => {
      if (fromScroll) {
        this.setState({
          isScrollLocked: this.props.isStreaming ? pagesBelow > 0 : false
        });
      }
      this.props.reportVisibleInterval({
        endKey: (0, _item.parseStreamItemId)(bottomChild),
        middleKey: (0, _item.parseStreamItemId)(middleChild),
        pagesAfterEnd: pagesBelow,
        pagesBeforeStart: pagesAbove,
        startKey: (0, _item.parseStreamItemId)(topChild),
        fromScroll
      });
    }));
    (0, _defineProperty2.default)(this, "handleJumpToTail", () => {
      const {
        items
      } = this.props;
      const lastItemTarget = (0, _item.getStreamItemId)(items[items.length - 1]);
      this.setState({
        targetId: lastItemTarget,
        isScrollLocked: false
      });
    });
    this.state = {
      target: null,
      targetId: null,
      items: props.items,
      isScrollLocked: false
    };
  }
  render() {
    var _this$props$hideScrol;
    const {
      columnConfigurations,
      currentHighlightKey,
      hasMoreAfterEnd,
      hasMoreBeforeStart,
      highlightedItem,
      isLoadingMore,
      isReloading,
      isStreaming,
      scale,
      wrap,
      startDateExpression,
      endDateExpression,
      lastLoadedTime,
      updateDateRange,
      startLiveStreaming,
      onOpenLogEntryFlyout,
      setContextEntry
    } = this.props;
    const hideScrollbar = (_this$props$hideScrol = this.props.hideScrollbar) !== null && _this$props$hideScrol !== void 0 ? _this$props$hideScrol : true;
    const {
      targetId,
      items,
      isScrollLocked
    } = this.state;
    const hasItems = items.length > 0;
    const hasFlyoutAction = !!onOpenLogEntryFlyout;
    const hasContextAction = !!setContextEntry;
    return /*#__PURE__*/_react.default.createElement(ScrollableLogTextStreamViewWrapper, null, isReloading && (!isStreaming || !hasItems) ? /*#__PURE__*/_react.default.createElement(_loading.LogsSharedLoadingPanel, {
      width: "100%",
      height: "100%",
      text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.logsShared.logs.scrollableLogTextStreamView.loadingEntriesLabel",
        defaultMessage: "Loading entries"
      })
    }) : !hasItems ? /*#__PURE__*/_react.default.createElement(_empty_states.NoData, {
      titleText: _i18n.i18n.translate('xpack.logsShared.logs.emptyView.noLogMessageTitle', {
        defaultMessage: 'There are no log messages to display.'
      }),
      bodyText: _i18n.i18n.translate('xpack.logsShared.logs.emptyView.noLogMessageDescription', {
        defaultMessage: 'Try adjusting your filter.'
      }),
      refetchText: _i18n.i18n.translate('xpack.logsShared.logs.emptyView.checkForNewDataButtonLabel', {
        defaultMessage: 'Check for new data'
      }),
      onRefetch: this.handleReload,
      testString: "logsNoDataPrompt"
    }) : /*#__PURE__*/_react.default.createElement(WithColumnWidths, {
      columnConfigurations: columnConfigurations,
      scale: scale
    }, ({
      columnWidths,
      CharacterDimensionsProbe
    }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(CharacterDimensionsProbe, null), /*#__PURE__*/_react.default.createElement(_column_headers.LogColumnHeaders, {
      columnConfigurations: columnConfigurations,
      columnWidths: columnWidths
    }), /*#__PURE__*/_react.default.createElement(_auto_sizer.AutoSizer, {
      bounds: true,
      content: true,
      detectAnyWindowResize: "height"
    }, ({
      measureRef,
      bounds: {
        height = 0
      },
      content: {
        width = 0
      }
    }) => /*#__PURE__*/_react.default.createElement(ScrollPanelSizeProbe, {
      ref: measureRef
    }, /*#__PURE__*/_react.default.createElement(_vertical_scroll_panel.VerticalScrollPanel, {
      height: height,
      width: width,
      onVisibleChildrenChange: this.handleVisibleChildrenChange,
      target: targetId,
      hideScrollbar: hideScrollbar,
      "data-test-subj": 'logStream',
      isLocked: isScrollLocked,
      entriesCount: items.length
    }, registerChild => items.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_loading_item_view.LogTextStreamLoadingItemView, {
      position: "start",
      isLoading: isLoadingMore,
      hasMore: hasMoreBeforeStart,
      timestamp: (0, _moment.default)(items[0].logEntry.cursor.time).valueOf(),
      isStreaming: false,
      startDateExpression: startDateExpression,
      endDateExpression: endDateExpression,
      onExtendRange: newDateExpression => updateDateRange({
        startDateExpression: newDateExpression
      })
    }), items.map((item, idx) => {
      const currentTime = item.logEntry.cursor.time;
      let showDate = false;
      if (idx > 0) {
        const prevTime = items[idx - 1].logEntry.cursor.time;
        showDate = !(0, _moment.default)(currentTime).isSame(prevTime, 'day');
      }
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        key: (0, _item.getStreamItemId)(item)
      }, showDate && /*#__PURE__*/_react.default.createElement(_log_date_row.LogDateRow, {
        time: currentTime
      }), /*#__PURE__*/_react.default.createElement(_measurable_item_view.MeasurableItemView, {
        register: registerChild,
        registrationKey: (0, _item.getStreamItemId)(item)
      }, itemMeasureRef => /*#__PURE__*/_react.default.createElement(_log_entry_row.LogEntryRow, {
        columnConfigurations: columnConfigurations,
        columnWidths: columnWidths,
        openFlyoutWithItem: hasFlyoutAction ? this.handleOpenFlyout : undefined,
        openViewLogInContext: hasContextAction ? this.handleOpenViewLogInContext : undefined,
        boundingBoxRef: itemMeasureRef,
        logEntry: item.logEntry,
        highlights: item.highlights,
        isActiveHighlight: !!currentHighlightKey && currentHighlightKey.gid === item.logEntry.id,
        scale: scale,
        wrap: wrap,
        isHighlighted: highlightedItem ? item.logEntry.id === highlightedItem : false
      })));
    }), /*#__PURE__*/_react.default.createElement(_loading_item_view.LogTextStreamLoadingItemView, {
      position: "end",
      isLoading: isStreaming || isLoadingMore,
      hasMore: hasMoreAfterEnd,
      isStreaming: isStreaming,
      timestamp: isStreaming && lastLoadedTime ? lastLoadedTime.getTime() : (0, _moment.default)(items[items.length - 1].logEntry.cursor.time).valueOf(),
      startDateExpression: startDateExpression,
      endDateExpression: endDateExpression,
      onExtendRange: newDateExpression => updateDateRange({
        endDateExpression: newDateExpression
      }),
      onStreamStart: () => startLiveStreaming()
    }), isScrollLocked && /*#__PURE__*/_react.default.createElement(_jump_to_tail.LogTextStreamJumpToTail, {
      width: width,
      onClickJump: this.handleJumpToTail
    })) : null))))));
  }
}

// eslint-disable-next-line import/no-default-export
exports.ScrollableLogTextStreamView = ScrollableLogTextStreamView;
(0, _defineProperty2.default)(ScrollableLogTextStreamView, "getDerivedStateFromProps", (nextProps, prevState) => {
  const hasNewTarget = nextProps.target && nextProps.target !== prevState.target;
  const hasItems = nextProps.items.length > 0;

  // Prevent new entries from being appended and moving the stream forward when
  // the user has scrolled up during live streaming
  const nextItems = hasItems && prevState.isScrollLocked ? prevState.items : nextProps.items;
  if (nextProps.isStreaming && hasItems) {
    return {
      target: nextProps.target,
      targetId: (0, _item.getStreamItemId)(nextProps.items[nextProps.items.length - 1]),
      items: nextItems
    };
  } else if (hasNewTarget && hasItems) {
    return {
      target: nextProps.target,
      targetId: (0, _item.getStreamItemId)((0, _item.getStreamItemBeforeTimeKey)(nextProps.items, nextProps.target)),
      items: nextItems,
      isScrollLocked: false
    };
  } else if (!hasItems) {
    return {
      target: null,
      targetId: null,
      items: [],
      isScrollLocked: false
    };
  } else if (hasItems && (nextItems.length !== prevState.items.length || nextItems[0] !== prevState.items[0])) {
    return {
      ...prevState,
      items: nextItems,
      isScrollLocked: false
    };
  }
  return {
    isScrollLocked: false
  };
});
var _default = ScrollableLogTextStreamView;
/**
 * If the above component wasn't a class component, this wouldn't be necessary
 * since the `useColumnWidths` hook could have been used directly.
 */
exports.default = _default;
const WithColumnWidths = ({
  children,
  columnConfigurations,
  scale
}) => {
  const childParams = (0, _log_entry_column.useColumnWidths)({
    columnConfigurations,
    scale
  });
  return children(childParams);
};
const ScrollableLogTextStreamViewWrapper = _common.euiStyled.div`
  overflow: hidden;
  display: flex;
  flex: 1 1 0%;
  flex-direction: column;
  align-items: stretch;
`;
const ScrollPanelSizeProbe = _common.euiStyled.div`
  overflow: hidden;
  flex: 1 1 0%;
`;