"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogTextStreamLoadingItemView = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var React = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _log_text_separator = require("./log_text_separator");
var _datemath = require("../../../utils/datemath");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TIMESTAMP_FORMAT = {
  hour12: false,
  month: 'short',
  day: 'numeric',
  hour: 'numeric',
  minute: 'numeric',
  second: 'numeric'
};
class LogTextStreamLoadingItemView extends React.PureComponent {
  render() {
    const {
      position,
      timestamp,
      startDateExpression,
      endDateExpression,
      className,
      hasMore,
      isLoading,
      isStreaming,
      onExtendRange,
      onStreamStart
    } = this.props;
    const shouldShowCta = !hasMore && !isStreaming;
    const extra = /*#__PURE__*/React.createElement(LoadingItemViewExtra, {
      justifyContent: "center",
      alignItems: "center",
      gutterSize: "m"
    }, isLoading || isStreaming ? /*#__PURE__*/React.createElement(ProgressSpinner, {
      kind: isStreaming ? 'streaming' : 'loading'
    }) : shouldShowCta ? /*#__PURE__*/React.createElement(ProgressCta, {
      position: position,
      onStreamStart: onStreamStart,
      onExtendRange: onExtendRange,
      startDateExpression: startDateExpression,
      endDateExpression: endDateExpression
    }) : null);
    return /*#__PURE__*/React.createElement(ProgressEntryWrapper, {
      className: className,
      position: position
    }, position === 'start' ? extra : null, /*#__PURE__*/React.createElement(ProgressMessage, {
      timestamp: timestamp,
      position: position,
      isStreaming: isStreaming
    }), position === 'end' ? extra : null);
  }
}
exports.LogTextStreamLoadingItemView = LogTextStreamLoadingItemView;
const LoadingItemViewExtra = (0, _common.euiStyled)(_eui.EuiFlexGroup)`
  height: 40px;
`;
const ProgressEntryWrapper = _common.euiStyled.div`
  padding-left: ${props => props.theme.eui.euiSizeS};
  padding-top: ${props => props.position === 'start' ? props.theme.eui.euiSizeL : props.theme.eui.euiSizeM};
  padding-bottom: ${props => props.position === 'end' ? props.theme.eui.euiSizeL : props.theme.eui.euiSizeM};
`;
const ProgressMessage = ({
  timestamp,
  position,
  isStreaming
}) => {
  const formattedTimestamp = isStreaming && position === 'end' ? /*#__PURE__*/React.createElement(_i18nReact.FormattedRelative, {
    units: "second",
    value: timestamp,
    updateInterval: 1
  }) : /*#__PURE__*/React.createElement(_i18nReact.FormattedTime, (0, _extends2.default)({
    value: timestamp
  }, TIMESTAMP_FORMAT));
  const message = position === 'start' ? /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.logsShared.logs.showingEntriesFromTimestamp",
    defaultMessage: "Showing entries from {timestamp}",
    values: {
      timestamp: formattedTimestamp
    }
  }) : isStreaming ? /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.logsShared.logs.lastUpdate",
    defaultMessage: "Last update {timestamp}",
    values: {
      timestamp: formattedTimestamp
    }
  }) : /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.logsShared.logs.showingEntriesUntilTimestamp",
    defaultMessage: "Showing entries until {timestamp}",
    values: {
      timestamp: formattedTimestamp
    }
  });
  return /*#__PURE__*/React.createElement(_log_text_separator.LogTextSeparator, null, /*#__PURE__*/React.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, message));
};
const ProgressSpinner = ({
  kind
}) => /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/React.createElement(_eui.EuiLoadingSpinner, {
  size: "l"
})), /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/React.createElement(_eui.EuiText, {
  size: "s"
}, kind === 'streaming' ? /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.logsShared.logs.streamingNewEntriesText",
  defaultMessage: "Streaming new entries"
}) : /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.logsShared.logs.loadingNewEntriesText",
  defaultMessage: "Loading new entries"
}))));
const ProgressCta = ({
  position,
  startDateExpression,
  endDateExpression,
  onExtendRange,
  onStreamStart
}) => {
  const rangeEdge = position === 'start' ? startDateExpression : endDateExpression;
  if (rangeEdge === 'now' && position === 'end') {
    return /*#__PURE__*/React.createElement(_eui.EuiButton, {
      "data-test-subj": "infraProgressCtaStreamLiveButton",
      onClick: onStreamStart,
      size: "s"
    }, /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logsShared.logs.streamLive",
      defaultMessage: "Stream live"
    }));
  }
  const iconType = position === 'start' ? 'arrowUp' : 'arrowDown';
  const extendedRange = position === 'start' ? (0, _datemath.extendDatemath)(startDateExpression, 'before', endDateExpression) : (0, _datemath.extendDatemath)(endDateExpression, 'after', startDateExpression);
  if (!extendedRange || !('diffUnit' in extendedRange)) {
    return null;
  }
  return /*#__PURE__*/React.createElement(_eui.EuiButton, {
    "data-test-subj": "infraProgressCtaButton",
    onClick: () => {
      if (typeof onExtendRange === 'function') {
        onExtendRange(extendedRange.value);
      }
    },
    iconType: iconType,
    size: "s"
  }, /*#__PURE__*/React.createElement(ProgressExtendMessage, {
    amount: extendedRange.diffAmount,
    unit: extendedRange.diffUnit
  }));
};
const ProgressExtendMessage = ({
  amount,
  unit
}) => {
  switch (unit) {
    case 'ms':
      return /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.logsShared.logs.extendTimeframeByMillisecondsButton",
        defaultMessage: "Extend time frame by {amount, number} {amount, plural, one {millisecond} other {milliseconds}}",
        values: {
          amount
        }
      });
    case 's':
      return /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.logsShared.logs.extendTimeframeBySecondsButton",
        defaultMessage: "Extend time frame by {amount, number} {amount, plural, one {second} other {seconds}}",
        values: {
          amount
        }
      });
    case 'm':
      return /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.logsShared.logs.extendTimeframeByMinutesButton",
        defaultMessage: "Extend time frame by {amount, number} {amount, plural, one {minute} other {minutes}}",
        values: {
          amount
        }
      });
    case 'h':
      return /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.logsShared.logs.extendTimeframeByHoursButton",
        defaultMessage: "Extend time frame by {amount, number} {amount, plural, one {hour} other {hours}}",
        values: {
          amount
        }
      });
    case 'd':
      return /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.logsShared.logs.extendTimeframeByDaysButton",
        defaultMessage: "Extend time frame by {amount, number} {amount, plural, one {day} other {days}}",
        values: {
          amount
        }
      });
    case 'w':
      return /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.logsShared.logs.extendTimeframeByWeeksButton",
        defaultMessage: "Extend time frame by {amount, number} {amount, plural, one {week} other {weeks}}",
        values: {
          amount
        }
      });
    case 'M':
      return /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.logsShared.logs.extendTimeframeByMonthsButton",
        defaultMessage: "Extend time frame by {amount, number} {amount, plural, one {month} other {months}}",
        values: {
          amount
        }
      });
    case 'y':
      return /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.logsShared.logs.extendTimeframeByYearsButton",
        defaultMessage: "Extend time frame by {amount, number} {amount, plural, one {year} other {years}}",
        values: {
          amount
        }
      });
    default:
      throw new TypeError('Unhandled unit: ' + unit);
  }
};