"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LogAIAssistant = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogAIAssistant = ({
  doc,
  observabilityAIAssistant: {
    ObservabilityAIAssistantContextualInsight
  }
}) => {
  const explainLogMessageMessages = (0, _react.useMemo)(() => {
    if (!doc) {
      return undefined;
    }
    const now = new Date().toISOString();
    return [{
      '@timestamp': now,
      message: {
        role: _public.MessageRole.User,
        content: `I'm looking at a log entry. Can you explain me what the log message means? Where it could be coming from, whether it is expected and whether it is an issue. Here's the context, serialized: ${JSON.stringify({
          logEntry: {
            fields: doc.fields
          }
        })} `
      }
    }];
  }, [doc]);
  const similarLogMessageMessages = (0, _react.useMemo)(() => {
    var _doc$fields$find;
    if (!doc) {
      return undefined;
    }
    const now = new Date().toISOString();
    const message = (_doc$fields$find = doc.fields.find(field => field.field === 'message')) === null || _doc$fields$find === void 0 ? void 0 : _doc$fields$find.value[0];
    return [{
      '@timestamp': now,
      message: {
        role: _public.MessageRole.User,
        content: `I'm looking at a log entry. Can you construct a Kibana KQL query that I can enter in the search bar that gives me similar log entries, based on the \`message\` field: ${message}`
      }
    }];
  }, [doc]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, ObservabilityAIAssistantContextualInsight && explainLogMessageMessages ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(ObservabilityAIAssistantContextualInsight, {
    title: _translations.explainLogMessageTitle,
    messages: explainLogMessageMessages,
    dataTestSubj: "obsAiAssistantInsightButtonExplainLogMessage"
  })) : null, ObservabilityAIAssistantContextualInsight && similarLogMessageMessages ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(ObservabilityAIAssistantContextualInsight, {
    title: _translations.similarLogMessagesTitle,
    messages: similarLogMessageMessages,
    dataTestSubj: "obsAiAssistantInsightButtonSimilarLogMessage"
  })) : null);
};

// eslint-disable-next-line import/no-default-export
exports.LogAIAssistant = LogAIAssistant;
var _default = LogAIAssistant;
exports.default = _default;