"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataViewTestSubj = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BASE_DATA_VIEW_TEST_SUBJ = 'logExplorerDataView';
const publicDataViewPatternsSet = new Set(['logs-*', 'logstash-*', 'filebeat-*']);
const getDataViewTestSubj = title => {
  if (publicDataViewPatternsSet.has(title)) {
    return [BASE_DATA_VIEW_TEST_SUBJ, cleanTitle(title)].join('_');
  }
  return BASE_DATA_VIEW_TEST_SUBJ;
};
exports.getDataViewTestSubj = getDataViewTestSubj;
const cleanTitle = title => title.slice(0, -2);