"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HighlightSection = HighlightSection;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CHILDREN_PER_SECTION = 6;
function HighlightSection({
  title,
  children,
  columns
}) {
  const validChildren = _react.default.Children.toArray(children).filter(Boolean);
  const childLength = validChildren.length;
  const shouldRenderSection = childLength > 0;
  const limitedChildren = validChildren.slice(0, CHILDREN_PER_SECTION - 1);
  const [showMore, setShowMore] = (0, _react.useState)(childLength > CHILDREN_PER_SECTION);
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: title
  });
  const hiddenCount = childLength - limitedChildren.length;
  const showMoreButtonLabel = (0, _translations.flyoutAccordionShowMoreText)(hiddenCount);
  const showMoreButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "left",
    css: {
      width: '80px'
    },
    onClick: () => {
      setShowMore(false);
    }
  }, showMoreButtonLabel);
  limitedChildren.push(showMoreButton);
  const accordionTitle = /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, title));
  const flexChildren = (showMore ? limitedChildren : validChildren).map((child, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: idx
  }, child));
  return shouldRenderSection ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: accordionId,
    buttonContent: accordionTitle,
    paddingSize: "m",
    initialIsOpen: true,
    "data-test-subj": `logExplorerFlyoutHighlightSection${title}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: columns,
    alignItems: "start",
    gutterSize: "m"
  }, flexChildren)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  })) : null;
}