"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutHeader = FlyoutHeader;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_doc_detail = require("./use_doc_detail");
var _log_level = require("./sub_components/log_level");
var _timestamp = require("./sub_components/timestamp");
var constants = _interopRequireWildcard(require("../../../common/constants"));
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FlyoutHeader({
  doc
}) {
  const {
    hasTimestamp,
    hasLogLevel,
    hasMessage,
    hasBadges,
    hasFlyoutHeader
  } = (0, _use_doc_detail.getDocDetailHeaderRenderFlags)(doc);
  const logLevelAndTimestamp = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, hasBadges && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "m",
    justifyContent: "flexEnd"
  }, hasLogLevel && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_log_level.LogLevel, {
    level: doc[constants.LOG_LEVEL_FIELD]
  })), hasTimestamp && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_timestamp.Timestamp, {
    timestamp: doc[constants.TIMESTAMP_FIELD]
  }))));
  return hasFlyoutHeader ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    "data-test-subj": "logExplorerFlyoutDetail"
  }, hasMessage ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    "data-test-subj": "logExplorerFlyoutLogMessage"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexEnd",
    gutterSize: "none",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, _translations.flyoutMessageLabel)), logLevelAndTimestamp)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    overflowHeight: 100,
    paddingSize: "m",
    isCopyable: true,
    language: "txt",
    fontSize: "m"
  }, doc[constants.MESSAGE_FIELD])))) : logLevelAndTimestamp) : null;
}