"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectorActions = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _utils = require("../utils");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SelectorActions = props => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, (0, _extends2.default)({
    flush: true,
    size: "s"
  }, props));
};
exports.SelectorActions = SelectorActions;
const ShowAllLogs = ({
  isSelected,
  onClick,
  ...props
}) => {
  const allLogs = (0, _utils.createAllLogDatasetsItem)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, (0, _extends2.default)({
    "data-test-subj": allLogs['data-test-subj'],
    onClick: onClick,
    iconType: isSelected ? 'check' : allLogs.iconType,
    label: _constants.showAllLogsLabel
  }, props));
};
SelectorActions.Action = _eui.EuiListGroupItem;
SelectorActions.ShowAllLogs = ShowAllLogs;