"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultSearch = exports.DEFAULT_CONTEXT = void 0;
var _dataset_selection = require("../../../../common/dataset_selection");
var _hashed_cache = require("../../../../common/hashed_cache");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultSearch = {
  name: '',
  sortOrder: 'asc'
};
exports.defaultSearch = defaultSearch;
const DEFAULT_CONTEXT = {
  selection: _dataset_selection.AllDatasetSelection.create(),
  searchCache: new _hashed_cache.HashedCache(),
  panelId: _constants.INTEGRATIONS_PANEL_ID,
  tabId: _constants.INTEGRATIONS_TAB_ID,
  search: defaultSearch
};
exports.DEFAULT_CONTEXT = DEFAULT_CONTEXT;