"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Integration = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _dataset = require("./dataset");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class Integration {
  constructor(integration) {
    var _integration$title;
    (0, _defineProperty2.default)(this, "id", void 0);
    (0, _defineProperty2.default)(this, "name", void 0);
    (0, _defineProperty2.default)(this, "title", void 0);
    (0, _defineProperty2.default)(this, "description", void 0);
    (0, _defineProperty2.default)(this, "icons", void 0);
    (0, _defineProperty2.default)(this, "status", void 0);
    (0, _defineProperty2.default)(this, "version", void 0);
    (0, _defineProperty2.default)(this, "datasets", void 0);
    this.id = integration.id;
    this.name = integration.name;
    this.title = (_integration$title = integration.title) !== null && _integration$title !== void 0 ? _integration$title : integration.name;
    this.description = integration.description;
    this.icons = integration.icons;
    this.status = integration.status;
    this.version = integration.version;
    this.datasets = integration.datasets;
  }
  static create(integration) {
    var _integration$title2;
    const integrationProps = {
      ...integration,
      id: `integration-${integration.name}-${integration.version}`,
      title: (_integration$title2 = integration.title) !== null && _integration$title2 !== void 0 ? _integration$title2 : integration.name
    };
    return new Integration({
      ...integrationProps,
      datasets: integration.dataStreams.map(dataset => _dataset.Dataset.create(dataset, integrationProps))
    });
  }
}
exports.Integration = Integration;