"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hydrateDatasetSelection = void 0;
var _all_dataset_selection = require("./all_dataset_selection");
var _single_dataset_selection = require("./single_dataset_selection");
var _unresolved_dataset_selection = require("./unresolved_dataset_selection");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hydrateDatasetSelection = datasetSelection => {
  if (datasetSelection.selectionType === 'all') {
    return _all_dataset_selection.AllDatasetSelection.create();
  }
  if (datasetSelection.selectionType === 'single') {
    return _single_dataset_selection.SingleDatasetSelection.fromSelection(datasetSelection.selection);
  }
  if (datasetSelection.selectionType === 'unresolved') {
    return _unresolved_dataset_selection.UnresolvedDatasetSelection.fromSelection(datasetSelection.selection);
  }
};
exports.hydrateDatasetSelection = hydrateDatasetSelection;