"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.encodeDatasetSelection = exports.decodeDatasetSelectionId = void 0;
var _rison = require("@kbn/rison");
var lz = _interopRequireWildcard(require("lz-string"));
var _runtime_types = require("../runtime_types");
var _errors = require("./errors");
var _types = require("./types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const encodeDatasetSelection = datasetSelectionPlain => {
  const safeDatasetSelection = (0, _runtime_types.decodeOrThrow)(_types.datasetSelectionPlainRT, message => new _errors.DatasetEncodingError(`The current dataset selection is invalid: ${message}"`))(datasetSelectionPlain);
  return lz.compressToBase64((0, _rison.encode)(safeDatasetSelection));
};
exports.encodeDatasetSelection = encodeDatasetSelection;
const decodeDatasetSelectionId = datasetSelectionId => {
  const risonDatasetSelection = lz.decompressFromBase64(datasetSelectionId);
  if (risonDatasetSelection === null || risonDatasetSelection === '') {
    throw new _errors.DatasetEncodingError('The stored id is not a valid compressed value.');
  }
  const decodedDatasetSelection = (0, _rison.decode)(risonDatasetSelection);
  const datasetSelection = (0, _runtime_types.decodeOrThrow)(_types.datasetSelectionPlainRT, message => new _errors.DatasetEncodingError(`The current dataset selection is invalid: ${message}"`))(decodedDatasetSelection);
  return datasetSelection;
};
exports.decodeDatasetSelectionId = decodeDatasetSelectionId;