"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkEditor = void 0;
var _uuid = require("uuid");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _content_management = require("../../../common/content_management");
var _links_strings = require("../links_strings");
var _types = require("../../embeddable/types");
var _link_options = require("./link_options");
var _link_destination = require("./link_destination");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const LinkEditor = ({
  link,
  onSave,
  onClose,
  parentDashboard
}) => {
  var _link$type, _link$label;
  const [selectedLinkType, setSelectedLinkType] = (0, _react.useState)((_link$type = link === null || link === void 0 ? void 0 : link.type) !== null && _link$type !== void 0 ? _link$type : _content_management.DASHBOARD_LINK_TYPE);
  const [defaultLinkLabel, setDefaultLinkLabel] = (0, _react.useState)();
  const [currentLinkLabel, setCurrentLinkLabel] = (0, _react.useState)((_link$label = link === null || link === void 0 ? void 0 : link.label) !== null && _link$label !== void 0 ? _link$label : '');
  const [linkOptions, setLinkOptions] = (0, _react.useState)();
  const [linkDestination, setLinkDestination] = (0, _react.useState)(link === null || link === void 0 ? void 0 : link.destination);
  const linkTypes = (0, _react.useMemo)(() => {
    return [_content_management.DASHBOARD_LINK_TYPE, _content_management.EXTERNAL_LINK_TYPE].map(type => {
      return {
        id: type,
        label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          alignItems: "center",
          "aria-label": _types.LinkInfo[type].description
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: _types.LinkInfo[type].icon,
          color: "text"
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, _types.LinkInfo[type].displayName)),
        'data-test-subj': `links--linkEditor--${type}--radioBtn`
      };
    });
  }, []);

  /** When a new destination is picked, handle the logic for what to display as the current + default labels */
  const handleDestinationPicked = (0, _react.useCallback)((destination, label) => {
    setLinkDestination(destination);
    if (!currentLinkLabel || defaultLinkLabel === currentLinkLabel) {
      setCurrentLinkLabel(label !== null && label !== void 0 ? label : '');
    }
    setDefaultLinkLabel(label);
  }, [defaultLinkLabel, currentLinkLabel]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, {
    className: 'linkEditor in',
    "data-test-subj": "links--linkEditor--flyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    className: "linkEditorBackButton",
    flush: "left",
    color: "text",
    iconType: 'arrowLeft',
    onClick: () => onClose()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    "aria-label": _links_strings.LinksStrings.editor.linkEditor.getGoBackAriaLabel()
  }, /*#__PURE__*/_react.default.createElement("h2", null, link ? _links_strings.LinksStrings.editor.getEditLinkTitle() : _links_strings.LinksStrings.editor.getAddButtonLabel())))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _links_strings.LinksStrings.editor.linkEditor.getLinkTypePickerLabel()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    options: linkTypes,
    idSelected: selectedLinkType,
    onChange: id => {
      if (currentLinkLabel === defaultLinkLabel) {
        var _link$label2;
        setCurrentLinkLabel((link === null || link === void 0 ? void 0 : link.type) === id ? (_link$label2 = link.label) !== null && _link$label2 !== void 0 ? _link$label2 : '' : '');
      }
      setSelectedLinkType(id);
    }
  })), /*#__PURE__*/_react.default.createElement(_link_destination.LinkDestination, {
    link: link,
    parentDashboard: parentDashboard,
    selectedLinkType: selectedLinkType,
    setDestination: handleDestinationPicked
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _links_strings.LinksStrings.editor.linkEditor.getLinkTextLabel()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: (linkDestination ? defaultLinkLabel : '') || _links_strings.LinksStrings.editor.linkEditor.getLinkTextPlaceholder(),
    value: currentLinkLabel,
    onChange: e => setCurrentLinkLabel(e.target.value),
    "data-test-subj": "links--linkEditor--linkLabel--input"
  })), /*#__PURE__*/_react.default.createElement(_link_options.LinkOptionsComponent, {
    link: link,
    setLinkOptions: setLinkOptions,
    selectedLinkType: selectedLinkType
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => onClose(),
    iconType: "cross",
    "data-test-subj": "links--linkEditor--closeBtn"
  }, _links_strings.LinksStrings.editor.getCancelButtonLabel())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: !linkDestination,
    onClick: () => {
      // this check should always be true, since the button is disabled otherwise - this is just for type safety
      if (linkDestination) {
        var _link$id;
        onSave({
          label: currentLinkLabel === defaultLinkLabel ? undefined : currentLinkLabel,
          type: selectedLinkType,
          id: (_link$id = link === null || link === void 0 ? void 0 : link.id) !== null && _link$id !== void 0 ? _link$id : (0, _uuid.v4)(),
          destination: linkDestination,
          options: linkOptions
        });
        onClose();
      }
    },
    "data-test-subj": "links--linkEditor--saveBtn"
  }, link ? _links_strings.LinksStrings.editor.getUpdateButtonLabel() : _links_strings.LinksStrings.editor.getAddButtonLabel())))));
};
exports.LinkEditor = LinkEditor;