"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardLinkDestinationPicker = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _lodash = require("lodash");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _useUnmount = _interopRequireDefault(require("react-use/lib/useUnmount"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _dashboard_link_strings = require("./dashboard_link_strings");
var _dashboard_link_tools = require("./dashboard_link_tools");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DashboardLinkDestinationPicker = ({
  onDestinationPicked,
  initialSelection,
  parentDashboard,
  onUnmount,
  ...other
}) => {
  const [searchString, setSearchString] = (0, _react.useState)('');
  const [selectedOption, setSelectedOption] = (0, _react.useState)([]);
  const parentDashboardId = parentDashboard === null || parentDashboard === void 0 ? void 0 : parentDashboard.select(state => state.componentState.lastSavedId);
  const getDashboardItem = (0, _react.useCallback)(dashboard => {
    return {
      key: dashboard.id,
      value: dashboard,
      label: dashboard.attributes.title,
      className: 'linksDashboardItem'
    };
  }, []);
  (0, _useMount.default)(async () => {
    if (initialSelection) {
      const dashboard = await (0, _dashboard_link_tools.fetchDashboard)(initialSelection).catch(() => {
        /**
         * Swallow the error that is thrown, since this just means the selected dashboard was deleted and
         * so we should treat this the same as "no previous selection."
         */
      });
      if (dashboard) {
        onDestinationPicked(dashboard);
        setSelectedOption([getDashboardItem(dashboard)]);
      } else {
        onDestinationPicked(undefined);
      }
    }
  });
  (0, _useUnmount.default)(() => {
    var _selectedOption$;
    /** Save the current selection so we can re-populate it if we switch back to this link editor */
    onUnmount((_selectedOption$ = selectedOption[0]) === null || _selectedOption$ === void 0 ? void 0 : _selectedOption$.key);
  });
  const {
    loading: loadingDashboardList,
    value: dashboardList
  } = (0, _useAsync.default)(async () => {
    const dashboards = await (0, _dashboard_link_tools.fetchDashboards)({
      search: searchString,
      parentDashboardId,
      selectedDashboardId: initialSelection
    });
    const dashboardOptions = (dashboards !== null && dashboards !== void 0 ? dashboards : []).map(dashboard => {
      return getDashboardItem(dashboard);
    });
    return dashboardOptions;
  }, [searchString, parentDashboardId, getDashboardItem]);
  const debouncedSetSearch = (0, _react.useMemo)(() => (0, _lodash.debounce)(newSearch => {
    setSearchString(newSearch);
  }, 250), [setSearchString]);
  const renderOption = (0, _react.useCallback)((option, searchValue, contentClassName) => {
    const {
      label,
      key: dashboardId
    } = option;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      className: contentClassName
    }, dashboardId === parentDashboardId && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, _dashboard_link_strings.DashboardLinkStrings.getCurrentDashboardLabel())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: 'linksPanelLinkText'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: searchValue,
      className: 'wrapText'
    }, label)));
  }, [parentDashboardId]);

  /* {...other} is needed so the EuiComboBox is treated as part of the form */
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, other, {
    async: true,
    fullWidth: true,
    className: 'linksDashboardPicker',
    isLoading: loadingDashboardList,
    "aria-label": _dashboard_link_strings.DashboardLinkStrings.getDashboardPickerAriaLabel(),
    placeholder: _dashboard_link_strings.DashboardLinkStrings.getDashboardPickerPlaceholder(),
    singleSelection: {
      asPlainText: true
    },
    options: dashboardList,
    onSearchChange: searchValue => {
      debouncedSetSearch(searchValue);
    },
    renderOption: renderOption,
    selectedOptions: selectedOption,
    onChange: option => {
      setSelectedOption(option);
      if (option.length > 0) {
        // single select is `true`, so there is only ever one item in the array
        onDestinationPicked(option[0].value);
      } else {
        onDestinationPicked(undefined);
      }
    },
    "data-test-subj": "links--linkEditor--dashboardLink--comboBox"
  }));
};
exports.DashboardLinkDestinationPicker = DashboardLinkDestinationPicker;