"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardLinkComponent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
var _analytics = require("@kbn/analytics");
var _public = require("@kbn/dashboard-plugin/public");
var _public2 = require("@kbn/presentation-util-plugin/public");
var _content_management = require("../../../common/content_management");
var _kibana_services = require("../../services/kibana_services");
var _links_hooks = require("../links_hooks");
var _dashboard_link_strings = require("./dashboard_link_strings");
var _dashboard_link_tools = require("./dashboard_link_tools");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DashboardLinkComponent = ({
  link,
  layout,
  onLoading,
  onRender
}) => {
  const linksEmbeddable = (0, _links_hooks.useLinks)();
  const [error, setError] = (0, _react.useState)();
  const dashboardContainer = linksEmbeddable.parent;
  const parentDashboardInput = (0, _useObservable.default)(dashboardContainer.getInput$());
  const parentDashboardId = dashboardContainer.select(state => state.componentState.lastSavedId);

  /** Fetch the dashboard that the link is pointing to */
  const {
    loading: loadingDestinationDashboard,
    value: destinationDashboard
  } = (0, _useAsync.default)(async () => {
    if (link.id !== parentDashboardId && link.destination) {
      /**
       * only fetch the dashboard if it's not the current dashboard - if it is the current dashboard,
       * use `dashboardContainer` and its corresponding state (title, description, etc.) instead.
       */
      const dashboard = await (0, _dashboard_link_tools.fetchDashboard)(link.destination).then(result => {
        setError(undefined);
        return result;
      }).catch(e => setError(e));
      return dashboard;
    }
  }, [link, parentDashboardId]);

  /**
   * Returns the title and description of the dashboard that the link points to; note that, if the link points to
   * the current dashboard, then we need to get the most up-to-date information via the `parentDashboardInput` - this
   * will respond to changes so that the link label/tooltip remains in sync with the dashboard title/description.
   */
  const [dashboardTitle, dashboardDescription] = (0, _react.useMemo)(() => {
    return link.destination === parentDashboardId ? [parentDashboardInput === null || parentDashboardInput === void 0 ? void 0 : parentDashboardInput.title, parentDashboardInput === null || parentDashboardInput === void 0 ? void 0 : parentDashboardInput.description] : [destinationDashboard === null || destinationDashboard === void 0 ? void 0 : destinationDashboard.attributes.title, destinationDashboard === null || destinationDashboard === void 0 ? void 0 : destinationDashboard.attributes.description];
  }, [link.destination, parentDashboardId, parentDashboardInput, destinationDashboard]);

  /**
   * Memoized link information
   */
  const linkLabel = (0, _react.useMemo)(() => {
    return link.label || (dashboardTitle !== null && dashboardTitle !== void 0 ? dashboardTitle : _dashboard_link_strings.DashboardLinkStrings.getDashboardErrorLabel());
  }, [link, dashboardTitle]);
  const {
    tooltipTitle,
    tooltipMessage
  } = (0, _react.useMemo)(() => {
    if (error) {
      return {
        tooltipTitle: _dashboard_link_strings.DashboardLinkStrings.getDashboardErrorLabel(),
        tooltipMessage: error.message
      };
    }
    return {
      tooltipTitle: Boolean(dashboardDescription) ? linkLabel : undefined,
      tooltipMessage: dashboardDescription || linkLabel
    };
  }, [error, linkLabel, dashboardDescription]);

  /**
   * Dashboard-to-dashboard navigation
   */
  const onClickProps = (0, _react.useMemo)(() => {
    /** If the link points to the current dashboard, then there should be no `onClick` or `href` prop */
    if (!link.destination || link.destination === parentDashboardId) return;
    const linkOptions = {
      ..._public2.DEFAULT_DASHBOARD_DRILLDOWN_OPTIONS,
      ...link.options
    };
    const params = {
      dashboardId: link.destination,
      ...(0, _public.getDashboardLocatorParamsFromEmbeddable)(linksEmbeddable, linkOptions)
    };
    const locator = dashboardContainer.locator;
    if (!locator) return;
    const href = locator.getRedirectUrl(params);
    return {
      href,
      onClick: async event => {
        _kibana_services.trackUiMetric === null || _kibana_services.trackUiMetric === void 0 ? void 0 : (0, _kibana_services.trackUiMetric)(_analytics.METRIC_TYPE.CLICK, `${_content_management.DASHBOARD_LINK_TYPE}:click`);

        /**
         * If the link is being opened via a modified click, then we should use the default `href` navigation behaviour
         * by passing all the dashboard state via the URL - this will keep behaviour consistent across all browsers.
         */
        const modifiedClick = event.ctrlKey || event.metaKey || event.shiftKey;
        if (modifiedClick) {
          return;
        }

        /** Otherwise, prevent the default behaviour and handle click depending on `openInNewTab` option */
        event.preventDefault();
        if (linkOptions.openInNewTab) {
          window.open(href, '_blank');
        } else {
          await locator.navigate(params);
        }
      }
    };
  }, [link, dashboardContainer.locator, linksEmbeddable, parentDashboardId]);
  (0, _react.useEffect)(() => {
    if (loadingDestinationDashboard) {
      onLoading();
    } else {
      onRender();
    }
  }, [link, linksEmbeddable, loadingDestinationDashboard, onLoading, onRender]);
  const id = `dashboardLink--${link.id}`;
  return loadingDestinationDashboard ? /*#__PURE__*/_react.default.createElement("li", {
    id: `${id}--loading`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    isLoading: true,
    "data-test-subj": `${id}--loading`
  }, _dashboard_link_strings.DashboardLinkStrings.getLoadingDashboardLabel())) : /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, (0, _extends2.default)({
    size: "s",
    color: "text"
  }, onClickProps, {
    id: `dashboardLink--${link.id}`,
    showToolTip: true,
    toolTipProps: {
      title: tooltipTitle,
      content: tooltipMessage,
      position: layout === _content_management.LINKS_VERTICAL_LAYOUT ? 'right' : 'bottom',
      repositionOnScroll: true,
      delay: 'long',
      'data-test-subj': `${id}--tooltip`
    },
    iconType: error ? 'warning' : undefined,
    iconProps: {
      className: 'dashboardLinkIcon'
    },
    isDisabled: Boolean(error),
    className: (0, _classnames.default)('linksPanelLink', {
      linkCurrent: link.destination === parentDashboardId,
      dashboardLinkError: Boolean(error),
      'dashboardLinkError--noLabel': !link.label
    }),
    label: linkLabel,
    "data-test-subj": error ? `${id}--error` : `${id}`
  }));
};
exports.DashboardLinkComponent = DashboardLinkComponent;