"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LicenseManagementUIPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _constants = require("../common/constants");
var _breadcrumbs = require("./application/breadcrumbs");
var _locator = require("./locator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
class LicenseManagementUIPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "breadcrumbService", new _breadcrumbs.BreadcrumbService());
    (0, _defineProperty2.default)(this, "locator", void 0);
    this.initializerContext = initializerContext;
  }
  setup(coreSetup, plugins) {
    const config = this.initializerContext.config.get();
    if (!config.ui.enabled) {
      // No need to go any further
      return {
        enabled: false,
        locator: this.locator
      };
    }
    const {
      getStartServices
    } = coreSetup;
    const {
      management,
      licensing,
      share
    } = plugins;
    this.locator = share.url.locators.create(new _locator.LicenseManagementLocatorDefinition({
      managementAppLocator: management.locator
    }));
    management.sections.section.stack.registerApp({
      id: _constants.PLUGIN.id,
      title: _constants.PLUGIN.title,
      order: 0,
      mount: async ({
        element,
        setBreadcrumbs,
        history,
        theme$
      }) => {
        const [coreStart, {
          telemetry
        }] = await getStartServices();
        const initialLicense = await (0, _rxjs.firstValueFrom)(plugins.licensing.license$);

        // Setup documentation links
        const {
          docLinks,
          chrome: {
            docTitle
          }
        } = coreStart;
        const appDocLinks = {
          security: docLinks.links.security.elasticsearchSettings
        };
        docTitle.change(_constants.PLUGIN.title);

        // Setup services
        this.breadcrumbService.setup(setBreadcrumbs);
        const appDependencies = {
          core: coreStart,
          config,
          plugins: {
            licensing,
            telemetry
          },
          services: {
            breadcrumbService: this.breadcrumbService,
            history
          },
          store: {
            initialLicense
          },
          docLinks: appDocLinks,
          theme$
        };
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        const unmountAppCallback = renderApp(element, appDependencies);
        return () => {
          docTitle.reset();
          unmountAppCallback();
        };
      }
    });
    return {
      enabled: true,
      locator: this.locator
    };
  }
  start() {}
  stop() {}
}
exports.LicenseManagementUIPlugin = LicenseManagementUIPlugin;