"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UploadLicense = void 0;
var _reactRedux = require("react-redux");
var _set_breadcrumb = require("../../store/actions/set_breadcrumb");
var _upload_license = require("../../store/actions/upload_license");
var _add_error_message = require("../../store/actions/add_error_message");
var _license_management = require("../../store/reducers/license_management");
var _upload_license2 = require("./upload_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapStateToProps = state => {
  return {
    isInvalid: (0, _license_management.isInvalid)(state),
    needsAcknowledgement: (0, _license_management.uploadNeedsAcknowledgement)(state),
    messages: (0, _license_management.uploadMessages)(state),
    errorMessage: (0, _license_management.getUploadErrorMessage)(state),
    applying: (0, _license_management.isApplying)(state),
    currentLicenseType: (0, _license_management.getLicenseType)(state) || ''
  };
};
const mapDispatchToProps = {
  addUploadErrorMessage: _add_error_message.addUploadErrorMessage,
  uploadLicense: _upload_license.uploadLicense,
  uploadLicenseStatus: _upload_license.uploadLicenseStatus,
  setBreadcrumb: _set_breadcrumb.setBreadcrumb
};
const UploadLicense = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_upload_license2.UploadLicense);
exports.UploadLicense = UploadLicense;