"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LineCurveOption = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/expression-xy-plugin/public");
var _line_curve_definitions = require("./line_curve_definitions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LineCurveOption = ({
  onChange,
  value = _public.XYCurveTypes.LINEAR,
  enabled = true
}) => {
  return enabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.xyChart.lineInterpolationLabel', {
      defaultMessage: 'Line interpolation'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    "data-test-subj": "lnsCurveStyleSelect",
    compressed: true,
    options: _line_curve_definitions.lineCurveDefinitions.map(({
      type,
      title,
      description
    }) => ({
      value: type,
      dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, title), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement("p", null, description))),
      inputDisplay: title
    })),
    valueOfSelected: value,
    onChange: onChange,
    itemLayoutAlign: "top",
    hasDividers: true
  })) : null;
};
exports.LineCurveOption = LineCurveOption;