"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataDimensionEditor = DataDimensionEditor;
exports.DataDimensionEditorDataSectionExtra = DataDimensionEditorDataSectionExtra;
exports.idPrefix = void 0;
exports.updateLayer = updateLayer;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _eui = require("@elastic/eui");
var _coloring = require("@kbn/coloring");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _state_helpers = require("../state_helpers");
var _shared_components = require("../../../shared_components");
var _visualization_helpers = require("../visualization_helpers");
var _collapse_setting = require("../../../shared_components/collapse_setting");
var _to_expression = require("../to_expression");
var _color_assignment = require("../color_assignment");
var _lens_ui_telemetry = require("../../../lens_ui_telemetry");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function updateLayer(state, layer, index) {
  const newLayers = [...state.layers];
  newLayers[index] = layer;
  return {
    ...state,
    layers: newLayers
  };
}
const idPrefix = (0, _eui.htmlIdGenerator)()();
exports.idPrefix = idPrefix;
function DataDimensionEditor(props) {
  var _layer$yConfig, _layer$palette, _props$frame$activeDa2, _table$rows;
  const {
    state,
    layerId,
    accessor,
    darkMode,
    isInlineEditing
  } = props;
  const index = state.layers.findIndex(l => l.layerId === layerId);
  const layer = state.layers[index];
  const canUseColorMapping = layer.colorMapping ? true : false;
  const [isPaletteOpen, setIsPaletteOpen] = (0, _react.useState)(false);
  const [useNewColorMapping, setUseNewColorMapping] = (0, _react.useState)(canUseColorMapping);
  const {
    inputValue: localState,
    handleInputChange: setLocalState
  } = (0, _visualizationUiComponents.useDebouncedValue)({
    value: props.state,
    onChange: props.setState
  });
  const localYConfig = layer === null || layer === void 0 ? void 0 : (_layer$yConfig = layer.yConfig) === null || _layer$yConfig === void 0 ? void 0 : _layer$yConfig.find(yAxisConfig => yAxisConfig.forAccessor === accessor);
  const axisMode = (localYConfig === null || localYConfig === void 0 ? void 0 : localYConfig.axisMode) || 'auto';
  const setConfig = (0, _react.useCallback)(yConfig => {
    if (yConfig == null) {
      return;
    }
    const newYConfigs = [...(layer.yConfig || [])];
    const existingIndex = newYConfigs.findIndex(yAxisConfig => yAxisConfig.forAccessor === accessor);
    if (existingIndex !== -1) {
      newYConfigs[existingIndex] = {
        ...newYConfigs[existingIndex],
        ...yConfig
      };
    } else {
      newYConfigs.push({
        forAccessor: accessor,
        ...yConfig
      });
    }
    setLocalState(updateLayer(localState, {
      ...layer,
      yConfig: newYConfigs
    }, index));
  }, [accessor, index, localState, layer, setLocalState]);
  const setColorMapping = (0, _react.useCallback)(colorMapping => {
    setLocalState(updateLayer(localState, {
      ...layer,
      colorMapping
    }, index));
  }, [index, localState, layer, setLocalState]);
  const setPalette = (0, _react.useCallback)(palette => {
    setLocalState(updateLayer(localState, {
      ...layer,
      palette
    }, index));
  }, [index, localState, layer, setLocalState]);
  const overwriteColor = (0, _state_helpers.getSeriesColor)(layer, accessor);
  const assignedColor = (0, _react.useMemo)(() => {
    var _props$frame$activeDa;
    const sortedAccessors = (0, _to_expression.getSortedAccessors)(props.frame.datasourceLayers[layer.layerId], layer);
    const colorAssignments = (0, _color_assignment.getColorAssignments)((0, _visualization_helpers.getDataLayers)(state.layers), {
      tables: (_props$frame$activeDa = props.frame.activeData) !== null && _props$frame$activeDa !== void 0 ? _props$frame$activeDa : {}
    }, props.formatFactory);
    return (0, _color_assignment.getAssignedColorConfig)({
      ...layer,
      accessors: sortedAccessors.filter(sorted => layer.accessors.includes(sorted))
    }, accessor, colorAssignments, props.frame, props.paletteService).color;
  }, [props.frame, props.paletteService, state.layers, accessor, props.formatFactory, layer]);
  const localLayer = layer;
  const colors = layer.colorMapping ? (0, _coloring.getColorsFromMapping)(props.darkMode, layer.colorMapping) : props.paletteService.get(((_layer$palette = layer.palette) === null || _layer$palette === void 0 ? void 0 : _layer$palette.name) || 'default').getCategoricalColors(10, layer.palette);
  const table = (_props$frame$activeDa2 = props.frame.activeData) === null || _props$frame$activeDa2 === void 0 ? void 0 : _props$frame$activeDa2[layer.layerId];
  const {
    splitAccessor
  } = layer;
  const splitCategories = (0, _chartExpressionsCommon.getColorCategories)((_table$rows = table === null || table === void 0 ? void 0 : table.rows) !== null && _table$rows !== void 0 ? _table$rows : [], splitAccessor);
  if (props.groupId === 'breakdown' && !layer.collapseFn) {
    var _layer$colorMapping;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "columnCompressed",
      label: _i18n.i18n.translate('xpack.lens.colorMapping.editColorMappingSectionlabel', {
        defaultMessage: 'Color mapping'
      }),
      style: {
        alignItems: 'center'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false,
      className: "lnsDynamicColoringClickable"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPaletteDisplay, {
      "data-test-subj": "lns_dynamicColoring_edit",
      palette: colors,
      type: 'fixed',
      onClick: () => {
        setIsPaletteOpen(!isPaletteOpen);
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "lns_colorEditing_trigger",
      "aria-label": _i18n.i18n.translate('xpack.lens.colorMapping.editColorMappingButton', {
        defaultMessage: 'Edit palette'
      }),
      iconType: "controlsHorizontal",
      onClick: () => {
        setIsPaletteOpen(!isPaletteOpen);
      },
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_shared_components.PalettePanelContainer, {
      siblingRef: props.panelRef,
      isOpen: isPaletteOpen,
      handleClose: () => setIsPaletteOpen(!isPaletteOpen),
      title: useNewColorMapping ? _i18n.i18n.translate('xpack.lens.colorMapping.editColorMappingTitle', {
        defaultMessage: 'Edit colors by term mapping'
      }) : _i18n.i18n.translate('xpack.lens.colorMapping.editColorsTitle', {
        defaultMessage: 'Edit colors'
      }),
      isInlineEditing: isInlineEditing
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "lnsPalettePanel__section lnsPalettePanel__section--shaded lnsIndexPatternDimensionEditor--padded"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s",
      justifyContent: "flexStart"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs"
      }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.lens.colorMapping.tryLabel', {
        defaultMessage: 'Use the new Color Mapping feature'
      }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow"
      }, _i18n.i18n.translate('xpack.lens.colorMapping.techPreviewLabel', {
        defaultMessage: 'Tech preview'
      })))),
      "data-test-subj": "lns_colorMappingOrLegacyPalette_switch",
      compressed: true,
      checked: useNewColorMapping,
      onChange: ({
        target: {
          checked
        }
      }) => {
        (0, _lens_ui_telemetry.trackUiCounterEvents)(`color_mapping_switch_${checked ? 'enabled' : 'disabled'}`);
        setColorMapping(checked ? {
          ..._coloring.DEFAULT_COLOR_MAPPING_CONFIG
        } : undefined);
        setUseNewColorMapping(checked);
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, canUseColorMapping || useNewColorMapping ? /*#__PURE__*/_react.default.createElement(_coloring.CategoricalColorMapping, {
      isDarkMode: darkMode,
      model: (_layer$colorMapping = layer.colorMapping) !== null && _layer$colorMapping !== void 0 ? _layer$colorMapping : {
        ..._coloring.DEFAULT_COLOR_MAPPING_CONFIG
      },
      onModelUpdate: model => setColorMapping(model),
      palettes: _coloring.AVAILABLE_PALETTES,
      data: {
        type: 'categories',
        categories: splitCategories
      },
      specialTokens: _coloring.SPECIAL_TOKENS_STRING_CONVERTION
    }) : /*#__PURE__*/_react.default.createElement(_shared_components.PalettePicker, {
      palettes: props.paletteService,
      activePalette: localLayer === null || localLayer === void 0 ? void 0 : localLayer.palette,
      setPalette: newPalette => {
        setPalette(newPalette);
      }
    }))))))));
  }
  const isHorizontal = (0, _state_helpers.isHorizontalChart)(state.layers);
  const disabledMessage = Boolean(!localLayer.collapseFn && localLayer.splitAccessor) ? _i18n.i18n.translate('xpack.lens.xyChart.colorPicker.tooltip.disabled', {
    defaultMessage: 'You are unable to apply custom colors to individual series when the layer includes a "Break down by" field.'
  }) : undefined;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.ColorPicker, (0, _extends2.default)({}, props, {
    overwriteColor: overwriteColor,
    defaultColor: assignedColor,
    disabledMessage: disabledMessage,
    setConfig: setConfig
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.xyChart.axisSide.label', {
      defaultMessage: 'Axis side'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: _i18n.i18n.translate('xpack.lens.xyChart.axisSide.label', {
      defaultMessage: 'Axis side'
    }),
    "data-test-subj": "lnsXY_axisSide_groups",
    name: "axisSide",
    buttonSize: "compressed",
    options: [{
      id: `${idPrefix}left`,
      label: isHorizontal ? _i18n.i18n.translate('xpack.lens.xyChart.axisSide.bottom', {
        defaultMessage: 'Bottom'
      }) : _i18n.i18n.translate('xpack.lens.xyChart.axisSide.left', {
        defaultMessage: 'Left'
      }),
      'data-test-subj': 'lnsXY_axisSide_groups_left'
    }, {
      id: `${idPrefix}auto`,
      label: _i18n.i18n.translate('xpack.lens.xyChart.axisSide.auto', {
        defaultMessage: 'Auto'
      }),
      'data-test-subj': 'lnsXY_axisSide_groups_auto'
    }, {
      id: `${idPrefix}right`,
      label: isHorizontal ? _i18n.i18n.translate('xpack.lens.xyChart.axisSide.top', {
        defaultMessage: 'Top'
      }) : _i18n.i18n.translate('xpack.lens.xyChart.axisSide.right', {
        defaultMessage: 'Right'
      }),
      'data-test-subj': 'lnsXY_axisSide_groups_right'
    }],
    idSelected: `${idPrefix}${axisMode}`,
    onChange: id => {
      const newMode = id.replace(idPrefix, '');
      setConfig({
        axisMode: newMode
      });
    }
  })));
}
function DataDimensionEditorDataSectionExtra(props) {
  const {
    state,
    layerId
  } = props;
  const index = state.layers.findIndex(l => l.layerId === layerId);
  const layer = state.layers[index];
  const {
    inputValue: localState,
    handleInputChange: setLocalState
  } = (0, _visualizationUiComponents.useDebouncedValue)({
    value: props.state,
    onChange: props.setState
  });
  if (props.groupId === 'breakdown') {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_collapse_setting.CollapseSetting, {
      value: layer.collapseFn || '',
      onChange: collapseFn => {
        setLocalState(updateLayer(localState, {
          ...layer,
          collapseFn
        }, index));
      }
    }));
  }
  return null;
}