"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTransposeColumnFilterHandler = exports.createGridSortingConfig = exports.createGridResizeHandler = exports.createGridHideHandler = exports.createGridFilterHandler = void 0;
var _transpose_helpers = require("../../../../common/expressions/datatable/transpose_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createGridResizeHandler = (columnConfig, setColumnConfig, onEditAction) => eventData => {
  const originalColumnId = (0, _transpose_helpers.getOriginalId)(eventData.columnId);
  // directly set the local state of the component to make sure the visualization re-renders immediately,
  // re-layouting and taking up all of the available space.
  setColumnConfig({
    ...columnConfig,
    columns: columnConfig.columns.map(column => {
      if (column.columnId === eventData.columnId || column.originalColumnId === originalColumnId) {
        return {
          ...column,
          width: eventData.width
        };
      }
      return column;
    })
  });
  return onEditAction({
    action: 'resize',
    columnId: originalColumnId,
    width: eventData.width
  });
};
exports.createGridResizeHandler = createGridResizeHandler;
const createGridHideHandler = (columnConfig, setColumnConfig, onEditAction) => eventData => {
  const originalColumnId = (0, _transpose_helpers.getOriginalId)(eventData.columnId);
  // directly set the local state of the component to make sure the visualization re-renders immediately
  setColumnConfig({
    ...columnConfig,
    columns: columnConfig.columns.map(column => {
      if (column.columnId === eventData.columnId || column.originalColumnId === originalColumnId) {
        return {
          ...column,
          hidden: true
        };
      }
      return column;
    })
  });
  return onEditAction({
    action: 'toggle',
    columnId: originalColumnId
  });
};
exports.createGridHideHandler = createGridHideHandler;
const createGridFilterHandler = (tableRef, onClickValue) => (field, value, colIndex, rowIndex, negate = false) => {
  const data = {
    negate,
    data: [{
      row: rowIndex,
      column: colIndex,
      value,
      table: tableRef.current
    }]
  };
  onClickValue(data);
};
exports.createGridFilterHandler = createGridFilterHandler;
const createTransposeColumnFilterHandler = (onClickValue, untransposedDataRef) => (bucketValues, negate = false) => {
  if (!untransposedDataRef.current) return;
  const originalTable = untransposedDataRef.current;
  const data = {
    negate,
    data: bucketValues.map(({
      originalBucketColumn,
      value
    }) => {
      const columnIndex = originalTable.columns.findIndex(c => c.id === originalBucketColumn.id);
      const rowIndex = originalTable.rows.findIndex(r => r[originalBucketColumn.id] === value);
      return {
        row: rowIndex,
        column: columnIndex,
        value,
        table: originalTable
      };
    })
  };
  onClickValue(data);
};
exports.createTransposeColumnFilterHandler = createTransposeColumnFilterHandler;
const createGridSortingConfig = (sortBy, sortDirection, onEditAction) => ({
  columns: !sortBy || sortDirection === 'none' ? [] : [{
    id: sortBy,
    direction: sortDirection
  }],
  onSort: sortingCols => {
    const newSortValue = sortingCols.length <= 1 ? sortingCols[0] : sortingCols[1];
    const isNewColumn = sortBy !== ((newSortValue === null || newSortValue === void 0 ? void 0 : newSortValue.id) || '');
    const nextDirection = newSortValue ? newSortValue.direction : 'none';
    return onEditAction({
      action: 'sort',
      columnId: nextDirection !== 'none' || isNewColumn ? newSortValue === null || newSortValue === void 0 ? void 0 : newSortValue.id : undefined,
      direction: nextDirection
    });
  }
});
exports.createGridSortingConfig = createGridSortingConfig;