"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLensAliasConfig = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../common/constants");
var _lens_client = require("./persistence/lens_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLensAliasConfig = () => ({
  alias: {
    path: (0, _constants.getBasePath)(),
    app: 'lens'
  },
  name: 'lens',
  promotion: true,
  title: _i18n.i18n.translate('xpack.lens.visTypeAlias.title', {
    defaultMessage: 'Lens'
  }),
  description: _i18n.i18n.translate('xpack.lens.visTypeAlias.description', {
    defaultMessage: 'Create visualizations with our drag and drop editor. Switch between visualization types at any time.'
  }),
  note: _i18n.i18n.translate('xpack.lens.visTypeAlias.note', {
    defaultMessage: 'Recommended for most users.'
  }),
  icon: 'lensApp',
  stage: 'production',
  appExtensions: {
    visualizations: {
      docTypes: ['lens'],
      searchFields: ['title^3'],
      clientOptions: {
        update: {
          overwrite: true
        }
      },
      client: _lens_client.getLensClient,
      toListItem(savedObject) {
        const {
          id,
          type,
          updatedAt,
          attributes
        } = savedObject;
        const {
          title,
          description
        } = attributes;
        return {
          id,
          title,
          description,
          updatedAt,
          editor: {
            editUrl: (0, _constants.getEditPath)(id),
            editApp: 'lens'
          },
          icon: 'lensApp',
          stage: 'production',
          savedObjectType: type,
          type: 'lens',
          typeTitle: _i18n.i18n.translate('xpack.lens.visTypeAlias.type', {
            defaultMessage: 'Lens'
          })
        };
      }
    }
  }
});
exports.getLensAliasConfig = getLensAliasConfig;