"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.executeAction = executeAction;
exports.isActionCompatible = isActionCompatible;
var _react = _interopRequireDefault(require("react"));
require("./helpers.scss");
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _public3 = require("@kbn/ui-actions-plugin/public");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function isActionCompatible(embeddable) {
  // display the action only if dashboard is on editable mode
  const inDashboardEditMode = embeddable.getInput().viewMode === 'edit';
  return Boolean((0, _utils.isLensEmbeddable)(embeddable) && embeddable.getIsEditable() && inDashboardEditMode);
}
async function executeAction({
  embeddable,
  startDependencies,
  overlays,
  theme
}) {
  const isCompatibleAction = await isActionCompatible(embeddable);
  if (!isCompatibleAction || !(0, _utils.isLensEmbeddable)(embeddable)) {
    throw new _public3.IncompatibleActionError();
  }
  const rootEmbeddable = embeddable.getRoot();
  const overlayTracker = (0, _public.tracksOverlays)(rootEmbeddable) ? rootEmbeddable : undefined;
  const ConfigPanel = await embeddable.openConfingPanel(startDependencies);
  if (ConfigPanel) {
    const handle = overlays.openFlyout((0, _public2.toMountPoint)( /*#__PURE__*/_react.default.cloneElement(ConfigPanel, {
      closeFlyout: () => {
        if (overlayTracker) overlayTracker.clearOverlays();
        handle.close();
      }
    }), {
      theme$: theme.theme$
    }), {
      className: 'lnsConfigPanel__overlay',
      size: 's',
      'data-test-subj': 'customizeLens',
      type: 'push',
      paddingSize: 'm',
      hideCloseButton: true,
      onClose: overlayRef => {
        if (overlayTracker) overlayTracker.clearOverlays();
        overlayRef.close();
      },
      outsideClickCloses: true
    });
    overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.openOverlay(handle, {
      focusedPanelId: embeddable.id
    });
  }
}