"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDiscoverHelpersAsync = exports.createOpenInDiscoverAction = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/ui-actions-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const ACTION_OPEN_IN_DISCOVER = 'ACTION_OPEN_IN_DISCOVER';
const getDiscoverHelpersAsync = async () => await Promise.resolve().then(() => _interopRequireWildcard(require('../async_services')));
exports.getDiscoverHelpersAsync = getDiscoverHelpersAsync;
const createOpenInDiscoverAction = (locator, dataViews, hasDiscoverAccess) => (0, _public.createAction)({
  type: ACTION_OPEN_IN_DISCOVER,
  id: ACTION_OPEN_IN_DISCOVER,
  order: 19,
  // right after Inspect which is 20
  getIconType: () => 'popout',
  getDisplayName: () => _i18n.i18n.translate('xpack.lens.app.exploreDataInDiscover', {
    defaultMessage: 'Explore data in Discover'
  }),
  getHref: async context => {
    const {
      getHref
    } = await getDiscoverHelpersAsync();
    return getHref({
      locator,
      dataViews,
      hasDiscoverAccess,
      ...context
    });
  },
  isCompatible: async context => {
    const {
      isCompatible
    } = await getDiscoverHelpersAsync();
    return isCompatible({
      hasDiscoverAccess,
      locator,
      dataViews,
      embeddable: context.embeddable
    });
  },
  execute: async context => {
    const {
      execute
    } = await getDiscoverHelpersAsync();
    return execute({
      ...context,
      locator,
      dataViews,
      hasDiscoverAccess
    });
  }
});
exports.createOpenInDiscoverAction = createOpenInDiscoverAction;