"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChangeIndexPattern = ChangeIndexPattern;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _calculateWidthFromCharCount = require("@kbn/calculate-width-from-char-count");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/unified-search-plugin/public");
var _react2 = require("@emotion/react");
var _trigger = require("./trigger");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ChangeIndexPattern({
  indexPatternRefs,
  isMissingCurrent,
  indexPatternId,
  onChangeIndexPattern,
  trigger,
  selectableProps
}) {
  const [isPopoverOpen, setPopoverIsOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_trigger.TriggerButton, (0, _extends2.default)({}, trigger, {
      isMissingCurrent: isMissingCurrent,
      togglePopover: () => setPopoverIsOpen(!isPopoverOpen)
    })),
    panelProps: {
      ['data-test-subj']: 'lnsChangeIndexPatternPopover'
    },
    isOpen: isPopoverOpen,
    closePopover: () => setPopoverIsOpen(false),
    display: "block",
    panelPaddingSize: "none",
    ownFocus: true
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          width: ${(0, _calculateWidthFromCharCount.calculateWidthFromEntries)(indexPatternRefs, ['name', 'id'], {
      minWidth: 320,
      maxWidth: 600
    })}px;
        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, _i18n.i18n.translate('xpack.lens.indexPattern.changeDataViewTitle', {
    defaultMessage: 'Data view'
  })), /*#__PURE__*/_react.default.createElement(_public.DataViewsList, {
    dataViewsList: indexPatternRefs,
    onChangeDataView: newId => {
      onChangeIndexPattern(newId);
      setPopoverIsOpen(false);
    },
    currentDataViewId: indexPatternId,
    selectableProps: selectableProps
  })));
}