"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AxisTitleSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _ = require("../..");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AxisTitleSettings = ({
  axis,
  axisTitle,
  updateTitleState,
  isAxisTitleVisible
}) => {
  const axisState = (0, _react.useMemo)(() => ({
    title: axisTitle,
    visibility: !axisTitle && isAxisTitleVisible ? 'auto' : isAxisTitleVisible ? 'custom' : 'none'
  }), [axisTitle, isAxisTitleVisible]);
  const onTitleChange = (0, _react.useCallback)(({
    title,
    visibility
  }) => updateTitleState({
    title,
    visible: visibility !== 'none'
  }, axis), [axis, updateTitleState]);
  const {
    inputValue: localAxisState,
    handleInputChange: onLocalTitleChange
  } = (0, _visualizationUiComponents.useDebouncedValue)({
    value: axisState,
    onChange: onTitleChange
  }, {
    allowFalsyValue: true
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.label.shared.axisHeader', {
      defaultMessage: 'Axis title'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_.VisLabel, {
    header: _i18n.i18n.translate('xpack.lens.shared.axisNameLabel', {
      defaultMessage: 'Axis title'
    }),
    dataTestSubj: `lns${axis}AxisTitle`,
    label: localAxisState.title,
    mode: localAxisState.visibility,
    placeholder: _i18n.i18n.translate('xpack.lens.shared.overwriteAxisTitle', {
      defaultMessage: 'Overwrite axis title'
    }),
    hasAutoOption: true,
    handleChange: ({
      mode,
      label
    }) => {
      onLocalTitleChange({
        title: label,
        visibility: mode
      });
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
};
exports.AxisTitleSettings = AxisTitleSettings;