"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AxisBoundsControl = AxisBoundsControl;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _range_input_field = require("../../range_input_field");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const idPrefix = (0, _eui.htmlIdGenerator)()();
function AxisBoundsControl({
  type,
  canHaveNiceValues,
  disableCustomRange,
  ...props
}) {
  var _extent$lowerBound, _extent$upperBound;
  const {
    extent,
    shouldIncludeZero,
    setExtent,
    dataBounds,
    testSubjPrefix
  } = props;
  const {
    inclusiveZeroError,
    boundaryError
  } = (0, _helpers.validateExtent)(shouldIncludeZero, extent);
  // Bucket type does not have the "full" mode
  const modeForNiceValues = type === 'metric' ? 'full' : 'dataBounds';
  const canShowNiceValues = canHaveNiceValues && extent.mode === modeForNiceValues;
  const canShowCustomRanges = (extent === null || extent === void 0 ? void 0 : extent.mode) === 'custom' && (type === 'bucket' || !disableCustomRange);
  const ModeAxisBoundsControl = type === 'metric' ? MetricAxisBoundsControl : BucketAxisBoundsControl;
  return /*#__PURE__*/_react.default.createElement(ModeAxisBoundsControl, (0, _extends2.default)({}, props, {
    disableCustomRange: disableCustomRange
  }), canShowNiceValues ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.fullExtent.niceValues', {
      defaultMessage: 'Round to nice values'
    }),
    display: "columnCompressedSwitch",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    showLabel: false,
    label: _i18n.i18n.translate('xpack.lens.fullExtent.niceValues', {
      defaultMessage: 'Round to nice values'
    }),
    "data-test-subj": `${testSubjPrefix}_axisExtent_niceValues`,
    checked: Boolean(extent.niceValues == null || extent.niceValues),
    onChange: () => {
      setExtent({
        ...extent,
        mode: modeForNiceValues,
        niceValues: !Boolean(extent.niceValues == null || extent.niceValues)
      });
    },
    compressed: true
  })) : null, canShowCustomRanges ? /*#__PURE__*/_react.default.createElement(_range_input_field.RangeInputField, {
    isInvalid: inclusiveZeroError || boundaryError,
    label: ' ',
    helpText: shouldIncludeZero && (!inclusiveZeroError || boundaryError) ? _i18n.i18n.translate('xpack.lens.axisExtent.inclusiveZero', {
      defaultMessage: 'Bounds must include zero.'
    }) : undefined,
    error: boundaryError ? _i18n.i18n.translate('xpack.lens.axisExtent.boundaryError', {
      defaultMessage: 'Lower bound has to be larger than upper bound'
    }) : shouldIncludeZero && inclusiveZeroError ? _i18n.i18n.translate('xpack.lens.axisExtent.inclusiveZero', {
      defaultMessage: 'Bounds must include zero.'
    }) : undefined,
    testSubjLayout: `${testSubjPrefix}_axisExtent_customBounds`,
    testSubjLower: `${testSubjPrefix}_axisExtent_lowerBound`,
    testSubjUpper: `${testSubjPrefix}_axisExtent_upperBound`,
    lowerValue: (_extent$lowerBound = extent.lowerBound) !== null && _extent$lowerBound !== void 0 ? _extent$lowerBound : '',
    onLowerValueChange: e => {
      const val = Number(e.target.value);
      const isEmptyValue = e.target.value === '' || Number.isNaN(Number(val));
      setExtent({
        ...extent,
        lowerBound: isEmptyValue ? undefined : val
      });
    },
    onLowerValueBlur: () => {
      if (extent.lowerBound === undefined && dataBounds) {
        setExtent({
          ...extent,
          lowerBound: Math.min(0, dataBounds.min)
        });
      }
    },
    upperValue: (_extent$upperBound = extent.upperBound) !== null && _extent$upperBound !== void 0 ? _extent$upperBound : '',
    onUpperValueChange: e => {
      const val = Number(e.target.value);
      const isEmptyValue = e.target.value === '' || Number.isNaN(Number(val));
      setExtent({
        ...extent,
        upperBound: isEmptyValue ? undefined : val
      });
    },
    onUpperValueBlur: () => {
      if (extent.upperBound === undefined && dataBounds) {
        setExtent({
          ...extent,
          upperBound: dataBounds.max
        });
      }
    }
  }) : null);
}
function MetricAxisBoundsControl({
  extent,
  setExtent,
  dataBounds,
  shouldIncludeZero,
  disableCustomRange,
  testSubjPrefix,
  children
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.axisExtent.label', {
      defaultMessage: 'Bounds'
    }),
    helpText: shouldIncludeZero ? _i18n.i18n.translate('xpack.lens.axisExtent.disabledDataBoundsMessage', {
      defaultMessage: 'Only line charts can be fit to the data bounds'
    }) : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: _i18n.i18n.translate('xpack.lens.axisExtent.label', {
      defaultMessage: 'Bounds'
    }),
    "data-test-subj": `${testSubjPrefix}_axisBounds_groups`,
    name: "axisBounds",
    buttonSize: "compressed",
    options: [{
      id: `${idPrefix}full`,
      label: _i18n.i18n.translate('xpack.lens.axisExtent.full', {
        defaultMessage: 'Full'
      }),
      'data-test-subj': `${testSubjPrefix}_axisExtent_groups_full'`
    }, {
      id: `${idPrefix}dataBounds`,
      label: _i18n.i18n.translate('xpack.lens.axisExtent.axisExtent.dataBounds', {
        defaultMessage: 'Data'
      }),
      'data-test-subj': `${testSubjPrefix}_axisExtent_groups_DataBounds'`,
      isDisabled: shouldIncludeZero
    }, {
      id: `${idPrefix}custom`,
      label: _i18n.i18n.translate('xpack.lens.axisExtent.axisExtent.custom', {
        defaultMessage: 'Custom'
      }),
      'data-test-subj': `${testSubjPrefix}_axisExtent_groups_custom'`,
      isDisabled: disableCustomRange
    }],
    idSelected: `${idPrefix}${shouldIncludeZero && extent.mode === 'dataBounds' || disableCustomRange ? 'full' : extent.mode}`,
    onChange: id => {
      const newMode = id.replace(idPrefix, '');
      setExtent({
        ...extent,
        mode: newMode,
        lowerBound: newMode === 'custom' && dataBounds ? Math.min(0, dataBounds.min) : undefined,
        upperBound: newMode === 'custom' && dataBounds ? dataBounds.max : undefined
      });
    }
  })), children);
}
function BucketAxisBoundsControl({
  extent,
  setExtent,
  dataBounds,
  testSubjPrefix,
  children
}) {
  var _extent$mode;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.axisExtent.label', {
      defaultMessage: 'Bounds'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: _i18n.i18n.translate('xpack.lens.axisExtent.label', {
      defaultMessage: 'Bounds'
    }),
    "data-test-subj": `${testSubjPrefix}_axisBounds_groups`,
    name: "axisBounds",
    buttonSize: "compressed",
    options: [{
      id: `${idPrefix}dataBounds`,
      label: _i18n.i18n.translate('xpack.lens.axisExtent.dataBounds', {
        defaultMessage: 'Data'
      }),
      'data-test-subj': `${testSubjPrefix}_axisExtent_groups_DataBounds'`
    }, {
      id: `${idPrefix}custom`,
      label: _i18n.i18n.translate('xpack.lens.axisExtent.custom', {
        defaultMessage: 'Custom'
      }),
      'data-test-subj': `${testSubjPrefix}_axisExtent_groups_custom'`
    }],
    idSelected: `${idPrefix}${(_extent$mode = extent.mode) !== null && _extent$mode !== void 0 ? _extent$mode : 'dataBounds'}`,
    onChange: id => {
      const newMode = id.replace(idPrefix, '');
      setExtent({
        ...extent,
        mode: newMode,
        lowerBound: newMode === 'custom' && dataBounds ? dataBounds.min : undefined,
        upperBound: newMode === 'custom' && dataBounds ? dataBounds.max : undefined
      });
    }
  })), children);
}