"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEmbeddableComponent = getEmbeddableComponent;
var _react = _interopRequireWildcard(require("react"));
var _panelLoader = require("@kbn/panel-loader");
var _eui = require("@elastic/eui");
var _public = require("@kbn/embeddable-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Type-safe variant of by value embeddable input for Lens.
 * This can be used to hardcode certain Lens chart configurations within another app.
 */

function getEmbeddableComponent(core, plugins) {
  const {
    embeddable: embeddableStart,
    uiActions
  } = plugins;
  const factory = embeddableStart.getEmbeddableFactory('lens');
  return props => {
    var _input$extraActions;
    const input = {
      ...props
    };
    const hasActions = Boolean(input.withDefaultActions) || input.extraActions && ((_input$extraActions = input.extraActions) === null || _input$extraActions === void 0 ? void 0 : _input$extraActions.length) > 0;
    if (hasActions) {
      return /*#__PURE__*/_react.default.createElement(EmbeddablePanelWrapper, {
        factory: factory,
        uiActions: uiActions,
        actionPredicate: () => hasActions,
        input: input,
        extraActions: input.extraActions,
        showInspector: input.showInspector,
        withDefaultActions: input.withDefaultActions
      });
    }
    return /*#__PURE__*/_react.default.createElement(EmbeddableRootWrapper, {
      factory: factory,
      input: input
    });
  };
}
function EmbeddableRootWrapper({
  factory,
  input
}) {
  const [embeddable, loading, error] = (0, _public.useEmbeddableFactory)({
    factory,
    input
  });
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, null);
  }
  return /*#__PURE__*/_react.default.createElement(_public.EmbeddableRoot, {
    embeddable: embeddable,
    loading: loading,
    error: error,
    input: input
  });
}
const EmbeddablePanelWrapper = ({
  factory,
  uiActions,
  actionPredicate,
  input,
  extraActions,
  showInspector = true,
  withDefaultActions
}) => {
  const [embeddable, loading] = (0, _public.useEmbeddableFactory)({
    factory,
    input
  });
  (0, _react.useEffect)(() => {
    if (embeddable) {
      embeddable.updateInput(input);
    }
  }, [embeddable, input]);
  if (loading || !embeddable) {
    return /*#__PURE__*/_react.default.createElement(_panelLoader.PanelLoader, null);
  }
  return /*#__PURE__*/_react.default.createElement(_public.EmbeddablePanel, {
    hideHeader: false,
    embeddable: embeddable,
    getActions: async (triggerId, context) => {
      const actions = withDefaultActions ? await uiActions.getTriggerCompatibleActions(triggerId, context) : [];
      return [...(extraActions !== null && extraActions !== void 0 ? extraActions : []), ...actions];
    },
    hideInspector: !showInspector,
    actionPredicate: actionPredicate,
    showNotifications: false,
    showShadow: false,
    showBadges: false
  });
};