"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartSwitch = void 0;
require("./chart_switch.scss");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
var _suggestion_helpers = require("../suggestion_helpers");
var _lens_ui_errors = require("../../../lens_ui_errors");
var _state_management = require("../../../state_management");
var _id_generator = require("../../../id_generator/id_generator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function VisualizationSummary({
  visualizationMap,
  visualization
}) {
  const activeVisualization = visualizationMap[visualization.activeId || ''];
  if (!activeVisualization) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.lens.configPanel.selectVisualization', {
      defaultMessage: 'Select a visualization'
    }));
  }
  const description = activeVisualization.getDescription(visualization.state);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, description.icon && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    className: "lnsChartSwitch__summaryIcon",
    type: description.icon
  }), /*#__PURE__*/_react.default.createElement("span", {
    className: "lnsChartSwitch__summaryText"
  }, description.label));
}
const MAX_LIST_HEIGHT = 380;
const ENTRY_HEIGHT = 32;
function computeListHeight(list, maxHeight) {
  if (list.length === 0) {
    return 0;
  }
  return Math.min(list.length * ENTRY_HEIGHT, maxHeight);
}
function safeFnCall(action, defaultReturnValue) {
  try {
    return action();
  } catch (error) {
    (0, _lens_ui_errors.showMemoizedErrorNotification)(error);
    return defaultReturnValue;
  }
}
function getCurrentVisualizationId(activeVisualization, visualizationState) {
  return safeFnCall(() => activeVisualization.getVisualizationTypeId(visualizationState), undefined);
}
const ChartSwitch = /*#__PURE__*/(0, _react.memo)(function ChartSwitch(props) {
  const [flyoutOpen, setFlyoutOpen] = (0, _react.useState)(false);
  const dispatchLens = (0, _state_management.useLensDispatch)();
  const activeDatasourceId = (0, _state_management.useLensSelector)(_state_management.selectActiveDatasourceId);
  const visualization = (0, _state_management.useLensSelector)(_state_management.selectVisualization);
  const datasourceStates = (0, _state_management.useLensSelector)(_state_management.selectDatasourceStates);
  const commitSelection = selection => {
    setFlyoutOpen(false);
    (0, _suggestion_helpers.switchToSuggestion)(dispatchLens, {
      ...selection,
      visualizationState: selection.getVisualizationState()
    }, {
      clearStagedPreview: true
    });
    if (!selection.datasourceId && !selection.sameDatasources || selection.dataLoss === 'everything') {
      dispatchLens((0, _state_management.removeLayers)({
        visualizationId: visualization.activeId,
        layerIds: Object.keys(props.framePublicAPI.datasourceLayers)
      }));
    }
  };
  function getSelection(visualizationId, subVisualizationId) {
    var _layers$0$;
    const newVisualization = props.visualizationMap[visualizationId];
    const switchVisType = (type, state) => {
      if (props.visualizationMap[visualizationId].switchVisualizationType) {
        return safeFnCall(() => props.visualizationMap[visualizationId].switchVisualizationType(type, state), state);
      }
      return state;
    };
    const layers = Object.entries(props.framePublicAPI.datasourceLayers);
    const containsData = layers.some(([_layerId, datasource]) => datasource && datasource.getTableSpec().length > 0);
    // Always show the active visualization as a valid selection
    if (visualization.activeId === visualizationId && visualization.state && safeFnCall(() => newVisualization.getVisualizationTypeId(visualization.state) === subVisualizationId, false)) {
      return {
        visualizationId,
        subVisualizationId,
        dataLoss: 'nothing',
        keptLayerIds: Object.keys(props.framePublicAPI.datasourceLayers),
        getVisualizationState: () => switchVisType(subVisualizationId, visualization.state),
        sameDatasources: true
      };
    }
    const topSuggestion = getTopSuggestion(props, visualizationId, datasourceStates, visualization, newVisualization, subVisualizationId);
    let dataLoss;
    if (!containsData) {
      dataLoss = 'nothing';
    } else if (!topSuggestion) {
      dataLoss = 'everything';
    } else if (layers.length > 1 && layers.length !== topSuggestion.keptLayerIds.length) {
      dataLoss = 'layers';
    } else if (topSuggestion.columns !== ((_layers$0$ = layers[0][1]) === null || _layers$0$ === void 0 ? void 0 : _layers$0$.getTableSpec().length)) {
      dataLoss = 'columns';
    } else {
      dataLoss = 'nothing';
    }
    function addNewLayer() {
      const newLayerId = (0, _id_generator.generateId)();
      dispatchLens((0, _state_management.insertLayer)({
        datasourceId: activeDatasourceId,
        layerId: newLayerId
      }));
      return newLayerId;
    }
    return {
      visualizationId,
      subVisualizationId,
      dataLoss,
      getVisualizationState: topSuggestion ? () => switchVisType(subVisualizationId, newVisualization.initialize(addNewLayer, topSuggestion.visualizationState)) : () => switchVisType(subVisualizationId, newVisualization.initialize(addNewLayer, visualization.activeId === newVisualization.id ? visualization.state : undefined, visualization.activeId && props.visualizationMap[visualization.activeId].getMainPalette ? props.visualizationMap[visualization.activeId].getMainPalette(visualization.state) : undefined)),
      keptLayerIds: topSuggestion ? topSuggestion.keptLayerIds : [],
      datasourceState: topSuggestion ? topSuggestion.datasourceState : undefined,
      datasourceId: topSuggestion ? topSuggestion.datasourceId : undefined,
      sameDatasources: dataLoss === 'nothing' && visualization.activeId === newVisualization.id
    };
  }
  const [searchTerm, setSearchTerm] = (0, _react.useState)('');
  const {
    visualizationTypes,
    visualizationsLookup
  } = (0, _react.useMemo)(() => {
    if (!flyoutOpen) {
      return {
        visualizationTypes: [],
        visualizationsLookup: {}
      };
    }
    const subVisualizationId = visualization.activeId && props.visualizationMap[visualization.activeId] ? getCurrentVisualizationId(props.visualizationMap[visualization.activeId], visualization.state) : undefined;
    const lowercasedSearchTerm = searchTerm.toLowerCase();
    // reorganize visualizations in groups
    const grouped = {};
    // Will need it later on to quickly pick up the metadata from it
    const lookup = {};
    Object.entries(props.visualizationMap).forEach(([visualizationId, v]) => {
      for (const visualizationType of v.visualizationTypes) {
        var _visualizationType$fu;
        const isSearchMatch = visualizationType.label.toLowerCase().includes(lowercasedSearchTerm) || ((_visualizationType$fu = visualizationType.fullLabel) === null || _visualizationType$fu === void 0 ? void 0 : _visualizationType$fu.toLowerCase().includes(lowercasedSearchTerm));
        if (isSearchMatch) {
          grouped[visualizationType.groupLabel] = grouped[visualizationType.groupLabel] || {
            priority: 0,
            visualizations: []
          };
          const visualizationEntry = {
            ...visualizationType,
            visualizationId,
            selection: getSelection(visualizationId, visualizationType.id)
          };
          grouped[visualizationType.groupLabel].priority += visualizationType.sortPriority || 0;
          grouped[visualizationType.groupLabel].visualizations.push(visualizationEntry);
          lookup[`${visualizationId}:${visualizationType.id}`] = visualizationEntry;
        }
      }
    });
    return {
      visualizationTypes: Object.keys(grouped).sort((groupA, groupB) => {
        return grouped[groupB].priority - grouped[groupA].priority;
      }).flatMap(group => {
        const {
          visualizations
        } = grouped[group];
        if (visualizations.length === 0) {
          return [];
        }
        return [{
          key: group,
          label: group,
          isGroupLabel: true,
          'aria-label': group,
          'data-test-subj': `lnsChartSwitchPopover_${group}`
        }].concat(visualizations
        // alphabetical order within each group
        .sort((a, b) => {
          return (a.fullLabel || a.label).localeCompare(b.fullLabel || b.label);
        }).map(v => ({
          'aria-label': v.fullLabel || v.label,
          className: 'lnsChartSwitch__option',
          isGroupLabel: false,
          key: `${v.visualizationId}:${v.id}`,
          value: `${v.visualizationId}:${v.id}`,
          'data-test-subj': `lnsChartSwitchPopover_${v.id}`,
          label: v.fullLabel || v.label,
          prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            className: "lnsChartSwitch__chartIcon",
            type: v.icon || 'empty'
          }),
          append: v.selection.dataLoss !== 'nothing' || v.showExperimentalBadge ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            gutterSize: "xs",
            responsive: false,
            alignItems: "center",
            className: "lnsChartSwitch__append"
          }, v.selection.dataLoss !== 'nothing' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
            "aria-label": _i18n.i18n.translate('xpack.lens.chartSwitch.dataLossLabel', {
              defaultMessage: 'Warning'
            }),
            type: "warning",
            color: "warning",
            content: _i18n.i18n.translate('xpack.lens.chartSwitch.dataLossDescription', {
              defaultMessage: 'Selecting this visualization type will remove incompatible configuration options and multiple layers, if present'
            }),
            iconProps: {
              className: 'lnsChartSwitch__chartIcon',
              'data-test-subj': `lnsChartSwitchPopoverAlert_${v.id}`
            }
          })) : null, v.showExperimentalBadge ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
            color: "hollow"
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.lens.chartSwitch.experimentalLabel",
            defaultMessage: "Technical preview"
          }))) : null) : null,
          // Apparently checked: null is not valid for TS
          ...(subVisualizationId === v.id && {
            checked: 'on'
          })
        })));
      }),
      visualizationsLookup: lookup
    };
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [flyoutOpen, props.visualizationMap, props.framePublicAPI, visualization.activeId, visualization.state, searchTerm]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsChartSwitch__header"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "lnsChartSwitchPopover",
    ownFocus: true,
    initialFocus: ".lnsChartSwitch__popoverPanel",
    panelClassName: "lnsChartSwitch__popoverPanel",
    panelPaddingSize: "s",
    button: /*#__PURE__*/_react.default.createElement(_sharedUxButtonToolbar.ToolbarButton, {
      onClick: () => setFlyoutOpen(!flyoutOpen),
      "data-test-subj": "lnsChartSwitchPopover",
      fontWeight: "bold",
      label: /*#__PURE__*/_react.default.createElement(VisualizationSummary, {
        visualization: visualization,
        visualizationMap: props.visualizationMap
      })
    }),
    isOpen: flyoutOpen,
    closePopover: () => setFlyoutOpen(false),
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, _i18n.i18n.translate('xpack.lens.configPanel.visualizationType', {
    defaultMessage: 'Visualization type'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    className: "lnsChartSwitch__options",
    height: computeListHeight(visualizationTypes, MAX_LIST_HEIGHT),
    searchable: true,
    singleSelection: true,
    isPreFiltered: true,
    "data-test-subj": "lnsChartSwitchList",
    searchProps: {
      className: 'lnsChartSwitch__search',
      'data-test-subj': 'lnsChartSwitchSearch',
      onChange: value => setSearchTerm(value)
    },
    options: visualizationTypes,
    onChange: newOptions => {
      const chosenType = newOptions.find(({
        checked
      }) => checked === 'on');
      if (!chosenType) {
        return;
      }
      const id = chosenType.value;
      commitSelection(visualizationsLookup[id].selection);
    },
    noMatchesMessage: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.lens.chartSwitch.noResults",
      defaultMessage: "No results found for {term}.",
      values: {
        term: /*#__PURE__*/_react.default.createElement("strong", null, searchTerm)
      }
    })
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, list))));
});
exports.ChartSwitch = ChartSwitch;
function getTopSuggestion(props, visualizationId, datasourceStates, visualization, newVisualization, subVisualizationId) {
  const mainPalette = visualization.activeId && props.visualizationMap[visualization.activeId] && props.visualizationMap[visualization.activeId].getMainPalette ? props.visualizationMap[visualization.activeId].getMainPalette(visualization.state) : undefined;
  const unfilteredSuggestions = (0, _suggestion_helpers.getSuggestions)({
    datasourceMap: props.datasourceMap,
    datasourceStates,
    visualizationMap: {
      [visualizationId]: newVisualization
    },
    activeVisualization: visualization.activeId ? props.visualizationMap[visualization.activeId] : undefined,
    visualizationState: visualization.state,
    subVisualizationId,
    activeData: props.framePublicAPI.activeData,
    mainPalette,
    dataViews: props.framePublicAPI.dataViews
  });
  const suggestions = unfilteredSuggestions.filter(suggestion => {
    // don't use extended versions of current data table on switching between visualizations
    // to avoid confusing the user.
    return suggestion.changeType !== 'extended' && safeFnCall(() => newVisualization.getVisualizationTypeId(suggestion.visualizationState) === subVisualizationId, false);
  });
  return suggestions.find(s => s.changeType === 'unchanged' || s.changeType === 'reduced') || suggestions[0];
}