"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cardinalityOperation = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _public = require("@kbn/expressions-plugin/public");
var _helpers = require("./helpers");
var _time_scale_utils = require("../time_scale_utils");
var _layer_helpers = require("../layer_helpers");
var _reduced_time_range_utils = require("../../reduced_time_range_utils");
var _get_group_by_key = require("./get_group_by_key");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const supportedTypes = new Set(['string', 'boolean', 'number', 'number_range', 'ip', 'ip_range', 'date', 'date_range', 'murmur3']);
const SCALE = 'ratio';
const OPERATION_TYPE = 'unique_count';
const IS_BUCKETED = false;
function ofName(name, timeShift, reducedTimeRange) {
  return (0, _time_scale_utils.adjustTimeScaleLabelSuffix)(_i18n.i18n.translate('xpack.lens.indexPattern.cardinalityOf', {
    defaultMessage: 'Unique count of {name}',
    values: {
      name
    }
  }), undefined, undefined, undefined, timeShift, undefined, reducedTimeRange);
}
const cardinalityOperation = {
  type: OPERATION_TYPE,
  displayName: _i18n.i18n.translate('xpack.lens.indexPattern.cardinality', {
    defaultMessage: 'Unique count'
  }),
  allowAsReference: true,
  input: 'field',
  getPossibleOperationForField: ({
    aggregationRestrictions,
    aggregatable,
    type,
    timeSeriesMetric
  }) => {
    if (supportedTypes.has(type) && aggregatable && timeSeriesMetric !== 'counter' && (!aggregationRestrictions || aggregationRestrictions.cardinality)) {
      return {
        dataType: 'number',
        isBucketed: IS_BUCKETED,
        scale: SCALE
      };
    }
  },
  getErrorMessage: (layer, columnId, indexPattern) => (0, _helpers.combineErrorMessages)([(0, _helpers.getInvalidFieldMessage)(layer, columnId, indexPattern), (0, _reduced_time_range_utils.getColumnReducedTimeRangeError)(layer, columnId, indexPattern)]),
  isTransferable: (column, newIndexPattern) => {
    const newField = newIndexPattern.getFieldByName(column.sourceField);
    return Boolean(newField && supportedTypes.has(newField.type) && newField.aggregatable && (!newField.aggregationRestrictions || newField.aggregationRestrictions.cardinality));
  },
  filterable: true,
  shiftable: true,
  canReduceTimeRange: true,
  getDefaultLabel: (column, columns, indexPattern) => ofName((0, _helpers.getSafeName)(column.sourceField, indexPattern), column.timeShift, column.reducedTimeRange),
  buildColumn({
    field,
    previousColumn
  }, columnParams) {
    var _previousColumn$param;
    return {
      label: ofName(field.displayName, previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeShift, previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.reducedTimeRange),
      dataType: 'number',
      operationType: OPERATION_TYPE,
      scale: SCALE,
      sourceField: field.name,
      isBucketed: IS_BUCKETED,
      filter: (0, _helpers.getFilter)(previousColumn, columnParams),
      timeShift: (columnParams === null || columnParams === void 0 ? void 0 : columnParams.shift) || (previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeShift),
      reducedTimeRange: (columnParams === null || columnParams === void 0 ? void 0 : columnParams.reducedTimeRange) || (previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.reducedTimeRange),
      params: {
        ...(0, _helpers.getFormatFromPreviousColumn)(previousColumn),
        emptyAsNull: previousColumn && (0, _helpers.isColumnOfType)('unique_count', previousColumn) ? (_previousColumn$param = previousColumn.params) === null || _previousColumn$param === void 0 ? void 0 : _previousColumn$param.emptyAsNull : !(columnParams !== null && columnParams !== void 0 && columnParams.usedInMath)
      }
    };
  },
  getAdvancedOptions: ({
    layer,
    columnId,
    currentColumn,
    paramEditorUpdater
  }) => {
    var _currentColumn$params;
    return [{
      dataTestSubj: 'hide-zero-values',
      inlineElement: /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs"
        }, _i18n.i18n.translate('xpack.lens.indexPattern.hideZero', {
          defaultMessage: 'Hide zero values'
        })),
        labelProps: {
          style: {
            fontWeight: _uiTheme.euiThemeVars.euiFontWeightMedium
          }
        },
        checked: Boolean((_currentColumn$params = currentColumn.params) === null || _currentColumn$params === void 0 ? void 0 : _currentColumn$params.emptyAsNull),
        onChange: () => {
          var _currentColumn$params2;
          paramEditorUpdater((0, _layer_helpers.updateColumnParam)({
            layer,
            columnId,
            paramName: 'emptyAsNull',
            value: !((_currentColumn$params2 = currentColumn.params) !== null && _currentColumn$params2 !== void 0 && _currentColumn$params2.emptyAsNull)
          }));
        },
        compressed: true
      })
    }];
  },
  toEsAggsFn: (column, columnId) => {
    var _column$params;
    return (0, _public.buildExpressionFunction)('aggCardinality', {
      id: columnId,
      enabled: true,
      schema: 'metric',
      field: column.sourceField,
      // time shift is added to wrapping aggFilteredMetric if filter is set
      timeShift: column.filter ? undefined : column.timeShift,
      emptyAsNull: (_column$params = column.params) === null || _column$params === void 0 ? void 0 : _column$params.emptyAsNull
    }).toAst();
  },
  getGroupByKey: agg => {
    return (0, _get_group_by_key.getGroupByKey)(agg, ['aggCardinality'], [{
      name: 'field'
    }, {
      name: 'emptyAsNull',
      transformer: val => String(Boolean(val))
    }]);
  },
  onFieldChange: (oldColumn, field) => {
    return {
      ...oldColumn,
      label: ofName(field.displayName, oldColumn.timeShift, oldColumn.reducedTimeRange),
      sourceField: field.name
    };
  },
  documentation: {
    section: 'elasticsearch',
    signature: _i18n.i18n.translate('xpack.lens.indexPattern.cardinality.signature', {
      defaultMessage: 'field: string'
    }),
    description: _i18n.i18n.translate('xpack.lens.indexPattern.cardinality.documentation.markdown', {
      defaultMessage: `
Calculates the number of unique values of a specified field. Works for number, string, date and boolean values.

Example: Calculate the number of different products:
\`unique_count(product.name)\`

Example: Calculate the number of different products from the "clothes" group:
\`unique_count(product.name, kql='product.group=clothes')\`
      `
    })
  },
  quickFunctionDocumentation: _i18n.i18n.translate('xpack.lens.indexPattern.cardinality.documentation.quick', {
    defaultMessage: `
The number of unique values for a specified number, string, date, or boolean field.
      `
  })
};
exports.cardinalityOperation = cardinalityOperation;